﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>
#include <glv_binding.h>

#include "UsbDiag_Theme.h"
#include "UsbDiag_RootView.h"

namespace nnt {
namespace usb {

class RootContext : public glv::Window
                  , public glv::GLV
                  , public glv::ApplicationLoopCallback
{
    NN_DISALLOW_COPY( RootContext );
    NN_DISALLOW_MOVE( RootContext );

public:
    RootContext(const unsigned width, const unsigned height) NN_NOEXCEPT;

    ~RootContext() NN_NOEXCEPT;

    virtual void OnLoopAttached(glv::ApplicationLoopContext& context) NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnLoopDetached(glv::ApplicationLoopContext& context) NN_NOEXCEPT NN_OVERRIDE;

    virtual const glv::RequiredRestoration OnLoopBeforeSceneRenderer(
        glv::ApplicationLoopContext& context, const glv::HidEvents& events
    ) NN_NOEXCEPT NN_OVERRIDE;

    virtual const glv::RequiredRestoration OnLoopAfterSceneRenderer(
        glv::ApplicationLoopContext& context, const glv::HidEvents& events
    ) NN_NOEXCEPT NN_OVERRIDE;

private:
    glv::Style          m_RootStyle;                    //!< 安全フレーム背景色

    RootView            m_RootView;
};

} // ~usb
} // ~nnt
