﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "UsbDiag_UsbModel.h"

namespace nnt {
namespace usb {

class DeviceListView : public glv::Scroll
{
    NN_DISALLOW_COPY( DeviceListView );
    NN_DISALLOW_MOVE( DeviceListView );

public:
    DeviceListView(const glv::space_t width, const glv::space_t height) NN_NOEXCEPT;

    ~DeviceListView() NN_NOEXCEPT;

    virtual const char *className() const { return "DeviceListView"; };

private:
    glv::Table  *m_pTable;
    struct UpdateHandler : glv::DrawHandler {
        bool         needsUpdate;
        glv::Table  *pTable;

        UpdateHandler() NN_NOEXCEPT : needsUpdate(false), pTable(nullptr) { }

        void SetDeviceTable(glv::Table *p) NN_NOEXCEPT;

        virtual bool onDraw(glv::View& v, glv::GLV& g) NN_NOEXCEPT;
    } m_UpdateHandler;

private:
    static void OnDeviceUpdate(const glv::Notification& n) NN_NOEXCEPT;
};

} // ~usb
} // ~nnt
