﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_UserExceptionHandler.h>

#include <nnt.h>

#include <nn/usb/usb_Result.h>
#include <nn/usb/usb_Pm.h>

namespace nnt {
namespace usb {
namespace pm {

nn::usb::PmClient        g_PmClient;
nn::usb::UsbPowerState   g_State;
nn::os::SystemEventType *g_pEvent;

TEST(PmBasic, PmBasic)
{
    // initialize
    NNT_EXPECT_RESULT_SUCCESS(g_PmClient.Initialize());

    g_pEvent = g_PmClient.GetPowerEvent();

    // initial poll
    NNT_EXPECT_RESULT_SUCCESS(g_PmClient.GetPowerState(&g_State));

    // wait the event for 5 times
    for (int i = 0; i < 5; i++)
    {
        nn::os::WaitSystemEvent(g_pEvent);
        nn::os::ClearSystemEvent(g_pEvent);
        NNT_EXPECT_RESULT_SUCCESS(g_PmClient.GetPowerState(&g_State));
    }

    // teardown
    NNT_EXPECT_RESULT_SUCCESS(g_PmClient.Finalize());
}

} // namespace pm
} // namespace usb
} // namespace nnt
