﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/nn_Log.h>
#include <cstdlib>
#include <cstdio>
#include <memory.h>
#include <conio.h>
#include <Windows.h> // for Sleep function
#include "PwrUSBInc.h"

enum Commands
{
    POWER_ON = 0,
    POWER_OFF,
    RESET,
    NUM_COMMANDS,
};

int WaitForPowerOff = 15000; // miliseconds
bool g_PwrUsbInit = 0;
int g_OutletRead[3];
int g_OutletSet[3];

int Reset();
int PowerOff();
int PowerOn();

int main(int argc, char* argv[])
{
    int status = 0;
    int maxUnits = 0;
    int model = 0;
    char firmware[32];
    int connected = 0;
    bool isResetRequested = false;

    for (int i = 1; i < argc; i++)
    {
        if (argv[i][0] < '3')   // outlet states
        {
            g_OutletSet[i - 1] = atoi(argv[i]);
        }
        if (argv[i][0] == '2')
        {
            isResetRequested = true;
        }
        if (i == 4)
        {
            if (atoi(argv[i]) > WaitForPowerOff)
            {
                WaitForPowerOff = atoi(argv[i]);
            }
            else
            {
                NN_LOG("Min reset dealy = %d, set to min. \n", WaitForPowerOff);
            }
        }
    }

    // TODO: Wrong argument format
    if (argc < 4 || argc > 5)
    {
        NN_LOG("Usage: PowerUsbControl.exe [0-2] [0-2] [0-2] [Miliseconds delay for reset]\n");
        NN_LOG("Example: PowerUsbControl.exe 2 2 0 10000\n");
        NN_LOG("(0 for off, 1 for on, 2 for hard reset), (Default reset delay = 15000 ms [min. = 10000ms])\n");
        return -1;
    }

    if ((maxUnits = InitPowerUSB(&model, firmware)) > 0)
    {
        g_PwrUsbInit = true;
        connected = CheckStatusPowerUSB();
    }

    if (maxUnits > 0)   // set to first pwrusb unit
        SetCurrentPowerUSB(0);
    NN_LOG("PowerUSB Connected. Number of Devices:%d Model: %d. Version:%s\n", maxUnits, model, firmware);

    ReadPortStatePowerUSB(&g_OutletRead[0], &g_OutletRead[1], &g_OutletRead[2]);
    NN_LOG("Current Port State: %d %d %d\n", g_OutletRead[0], g_OutletRead[1], g_OutletRead[2]);

    if (isResetRequested)
    {
        status = Reset();
    }
    else
    {
        status = SetPortPowerUSB(g_OutletSet[0], g_OutletSet[1], g_OutletSet[2]);
    }

    ReadPortStatePowerUSB(&g_OutletRead[0], &g_OutletRead[1], &g_OutletRead[2]);
    NN_LOG("Final Port State: %d %d %d\n", g_OutletRead[0], g_OutletRead[1], g_OutletRead[2]);

    if (g_PwrUsbInit)
    {
        status = ClosePowerUSB();
        g_PwrUsbInit = false;
    }

    return status;
}

int Reset()
{
    int status = 0;
    int outlet[3];

    for (int i = 0; i < 3; i++)
    {
        if (g_OutletSet[i] == RESET)
        {
            outlet[i] = 0;
        }
        else
        {
            outlet[i] = g_OutletSet[i];
        }
    }

    status = SetPortPowerUSB(outlet[0], outlet[1], outlet[2]);
    Sleep(WaitForPowerOff);

    for (int i = 0; i < 3; i++)
    {
        if (g_OutletSet[i] == RESET)
        {
            outlet[i] = 1;
        }
        else
        {
            outlet[i] = g_OutletSet[i];
        }
    }
    status = SetPortPowerUSB(outlet[0], outlet[1], outlet[2]);
    Sleep(WaitForPowerOff); // Time for devices to reboot

    return status;
}

int PowerOff()
{
    return 0;
}

int PowerOn()
{
    return 0;
}
