﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nnt.h>
#include <nn/nn_Log.h>
#include <nn/nn_Windows.h>
#include <cstdio>
#include <thread>
#include <future>

const char ExitPattern[] = "Fx3MonExit";
const char FailedString[] = "FAIL:";
const int ReadTimeout = 120000;

enum FX3DebugMonitorResult
{
    FX3DebugMonitorResult_Success = 0,
    FX3DebugMonitorResult_CommOpenFailed,
    FX3DebugMonitorResult_ReadFailed,
};

HANDLE handle;
bool cont = true;
char buf[1];
char line[50];
FX3DebugMonitorResult Result = FX3DebugMonitorResult_Success;

FX3DebugMonitorResult COM_Open(LPCTSTR name)
{
    COMMTIMEOUTS timeouts;
    DCB dcb;
    HANDLE h = INVALID_HANDLE_VALUE;

    h = CreateFile(name, 0x80000000L,  0, 0, OPEN_EXISTING, FILE_FLAG_NO_BUFFERING | FILE_FLAG_WRITE_THROUGH, 0);
    if (h == INVALID_HANDLE_VALUE)
    {
        printf("Error: Create File Failed\n");
        goto error;
    }

    if (!ClearCommError(h, NULL, NULL))
    {
        printf("Error: Clear Comm Failed\n");
        goto error;
    }

    if (!SetupComm(h, 512, 512))
    {
        printf("Error: Setup Comm Failed\n");
        goto error;
    }

    if (!PurgeComm(h, PURGE_TXABORT | PURGE_RXABORT |
                      PURGE_TXCLEAR | PURGE_RXCLEAR))
    {
        printf("Error: Purge Comm Failed\n");
        goto error;
    }

    memset(&timeouts, 0, sizeof(timeouts));
    timeouts.ReadTotalTimeoutConstant = ReadTimeout;
    if (!SetCommTimeouts(h, &timeouts))
    {
        printf("Error: Set Comm Timeout Failed\n");
        goto error;
    }

    memset(&dcb, 0, sizeof(dcb));
    dcb.DCBlength = sizeof(dcb);
    dcb.BaudRate = 115200;
    dcb.fBinary = TRUE;
    dcb.Parity = NOPARITY;
    dcb.ByteSize = 8;
    dcb.StopBits = ONESTOPBIT;

    if (!SetCommState(h, &dcb))
    {
        goto error;
    }

    if (!SetCommMask(h, 0))
    {
        goto error;
    }

    handle = h;
    return FX3DebugMonitorResult_Success;
error:
    printf("Error: Failed to open COM port %ls\n", name);
    if( h != INVALID_HANDLE_VALUE)
    {
        CloseHandle(h);
    }
    handle = NULL;
    return FX3DebugMonitorResult_CommOpenFailed;
}

void Read()
{
    int count = 0;
    Result = FX3DebugMonitorResult_Success;

    while (cont)
    {
        DWORD read;
        if (!ReadFile(handle, buf, sizeof(buf), &read, NULL))
        {
            printf("Failed to read COM port\n");
            Result = FX3DebugMonitorResult_ReadFailed;

            DWORD error = GetLastError();
            switch (error)
            {
            case ERROR_FILE_NOT_FOUND:
                printf("Error: File not found.\n");
                break;
            case ERROR_ACCESS_DENIED:
                printf("Error: Access Denied.\n");
                break;
            default:
                printf("Error code: %lu\n", error);
                break;
            }
            break;
        }
        if (read != sizeof(buf))
        {
            printf("Error: Expected bytes read: %zd Acutal bytes read: %d\n", sizeof(buf), read);
            cont = false;
            Result = FX3DebugMonitorResult_ReadFailed;
        }

        if (buf[0] != '\r')
        {
            line[count % 50] = buf[0];
            count++;
        }

        if (buf[0] == '\n' || count == 49)
        {
            line[count] = '\0';
            count = 0;
            printf("%s", line);
            if (memcmp(line, ExitPattern, sizeof(ExitPattern) - 1) == 0)
                cont = false;

            if (memcmp(line, FailedString, sizeof(FailedString) - 1) == 0)
            {
                printf("CI Failed string\n");
                cont = false;
                Result = FX3DebugMonitorResult_ReadFailed;
            }
        }

        // fflush(stdout);
    }

}

int main()
{
    Result = COM_Open(TEXT("\\\\.\\COM256"));
    if (Result != FX3DebugMonitorResult_Success)
    {
        // return Result;
        return FX3DebugMonitorResult_Success;
    }

    std::thread readThread(Read);

    readThread.join();

    if (handle != NULL)
    {
        CloseHandle(handle);
    }
    printf("Result: %d\n", Result);
    //return Result;
    return FX3DebugMonitorResult_Success;
}
