﻿
# boot プロセスでの更新確認も含めたテスト
# 手動実行用。通常モード K3-Unsigned 前提
#
# BootConfig を Sub 側にも書き込んでおく必要がある
# Externals/NxSystemImages/QspiBootTools/params-bc.bin を
# 00 00 01 00 00 00 00 00 00 00 80 00 00 04 00 00
# から
# 00 00 01 00 00 00 00 00 00 00 00 01 00 04 00 00
# に変更して Write-ProperBootConfig とか実行するとできる

KEY_TYPE="K5"
BUILD_TYPE="Develop"

RUN_ON_TARGET="$NINTENDO_SDK_ROOT/Tools/CommandLineTools/RunOnTarget.exe"
CONTROL_TARGET="$NINTENDO_SDK_ROOT/Tools/CommandLineTools/ControlTarget.exe"
DEVMENU_COMMAND_SYSTEM="$NINTENDO_SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Develop/DevMenuCommandSystem.nca"
BOOTIMAGE_PACKAGE=`cygpath -awl $NINTENDO_SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/SystemData/BootImagePackage-${KEY_TYPE}-Unsigned/${BUILD_TYPE}/BootImagePackage-${KEY_TYPE}-Unsigned.nsp`
BOOTIMAGE_PACKAGE_SAFE=`cygpath -awl $NINTENDO_SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/SystemData/BootImagePackageSafe-${KEY_TYPE}-Signed/${BUILD_TYPE}/BootImagePackageSafe-${KEY_TYPE}-Signed.nsp`
HELLO_WORLD="$NINTENDO_SDK_ROOT/Programs/Iris/Outputs/NX-NXFP2-a64/TargetTools/HelloWorld/${BUILD_TYPE}/HelloWorld.nca"


# BootImagePackage / BootImagePackageSafe のインストール
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram uninstall 0x0100000000000819
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram uninstall 0x010000000000081A
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram install $BOOTIMAGE_PACKAGE
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram install $BOOTIMAGE_PACKAGE_SAFE

# とりあえず正しい状態にする
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate update-bootimages
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate update-bootimages-safe
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate mark-verifying-required 0
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate mark-verifying-required-safe 0

# 初期ハッシュの確認
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-hashes

# 再起動
$RUN_ON_TARGET --reset $HELLO_WORLD --pattern-success-exit "Hello, world."

# phase4 は再起動すると、一度セーフモードに入るので別枠
PHASES="1 2 3 5 6"
for PHASE in $PHASES
do
    $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate mark-verifying-required 1
    $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate break-bootimages $PHASE
    $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-hashes

     # 再起動
    $RUN_ON_TARGET --reset $HELLO_WORLD --pattern-success-exit "Hello, world."
    $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-verifying-required-mark
    ## -> マークが 0 であることを目視で確認する
    $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-hashes
    ## -> ハッシュがそろっていることを目視で確認する
done

# 現状 phase4 になると復旧してくれないので封印
# # phase4
# $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate mark-verifying-required 1
# $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate break-bootimages 4
# $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-hashes

# # 再起動を二度行う
# $CONTROL_TARGET reset
# sleep 10
# $RUN_ON_TARGET --reset $HELLO_WORLD --pattern-success-exit "Hello, world."
# $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-verifying-required-mark
# ## -> マークが 0 であることを目視で確認する
# $RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-hashes
# ## -> ハッシュがそろっていることを目視で確認する


