﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/uart/uart.h>

#include <nnt/gtest/gtest.h>

#include "../TargetDevices/testUart_Bcm4356.h"

TEST( TargetSpecificJetsonTk2, Bcm4356 )
{
    const auto BaudRate        = nn::uart::BaudRate_115200;
    const auto FlowControlMode = nn::uart::FlowControlMode_Hardware;

    nnt::uart::bcm4356::TEST_BasicCommand(BaudRate, FlowControlMode);
    nnt::uart::bcm4356::TEST_Loopback(BaudRate, FlowControlMode);
}
