﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/uart/uart.h>

#include "../Common/testUart_Helper.h"

namespace nnt {
namespace uart {
namespace bcm4356 {
namespace details {

// UART 送受信バッファサイズ
// (ループバックテストで最大 8KB 近いデータが発生する可能性があるので大きめ)
const size_t UartBufferSize = 3 * nn::os::MemoryPageSize;

/*
 * HCI パケットのタイプ
 */
enum HciPacketType : char
{
    HciPacketType_Command   = 0x01,
    HciPacketType_AclData   = 0x02,
    HciPacketType_ScoData   = 0x03,
    HciPacketType_Event     = 0x04
};

/*
 * HCI パケットバッファの情報
 */
struct HciBufferInfo
{
    size_t  maxAclPacketSize;   // ACL パケットの最大サイズ
    size_t  maxScoPacketSize;   // SCO パケットの最大サイズ
    int     aclBufferCount;     // ACL パケットバッファ数
    int     scoBufferCount;     // SCO パケットバッファ数
};

/*
 * HCI コマンドを発行し、結果を取得します。
 */
void TransferCommand(size_t* pReceiveBytes,
                     char* pOutBuffer,
                     size_t outBufferSize,
                     nn::uart::PortSession* pSession,
                     const char* pCommand,
                     size_t commandSize,
                     bool isDumpData) NN_NOEXCEPT;

/*
 * 渡された情報をもとにループバックテストを実施します。
 */
void TEST_LoopbackBody(nn::uart::PortSession* pSession,
                       const HciBufferInfo& hciBufferInfo,
                       nn::uart::BaudRate baudRate) NN_NOEXCEPT;

}}}}
