﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/uart/uart.h>

#include "../Common/testUart_Helper.h"

namespace nnt {
namespace uart {
namespace bcm4356 {

/**
 * @brief       BCM4356 が基本的な HCI コマンドに応答することをテストします。
 *
 * @param[in]   baudRate          ボーレート
 * @param[in]   flowControlMode   フロー制御モード
 *
 * @details
 *  BCM4356 に対して HCI_Reset および HCI_Read_Local_Version_Information コマンドを発行し、期待通りの応答があるかをテストします。
 *  テスト内部で生成したセッションはクローズされ、ライブラリは未初期化状態に戻ります。
 */
void TEST_BasicCommand(nn::uart::BaudRate baudRate,
                       nn::uart::FlowControlMode flowControlMode) NN_NOEXCEPT;

/**
 * @brief       BCM4356 との通信をループバックモードを使用してテストします。
 *
 * @param[in]   baudRate          ボーレート
 * @param[in]   flowControlMode   フロー制御モード
 *
 * @details
 *  BCM4356 に対して HCI_Write_Loopback_Mode コマンドを発行し、ループバックを利用した通信をテストします。
 *  テスト内部で生成したセッションはクローズされ、ライブラリは未初期化状態に戻ります。
 */
void TEST_Loopback(nn::uart::BaudRate baudRate,
                   nn::uart::FlowControlMode flowControlMode) NN_NOEXCEPT;

}}}
