﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/cduac/cduac_Spec.h>
#include <nn/cduac/cduac_Api.h>

#include "..\UacCommon\UacCommon.h"

const int   InputsCount                 = 2;
const int   MillisecondsPerFrameCount   = 5;
const int   SamplesPerMillisecondCount  = 48;
const int   SamplesPerFrameCount        = MillisecondsPerFrameCount * SamplesPerMillisecondCount;
const int   BuffersCount                = 2;
const int   InputChannelsCount          = 1;                                        // input is mono
const int   OutputChannelsCount         = 2;                                        // output is stereo
const int   BytesPerSampleCount         = sizeof(int16_t);                          // 16 bit smples input output

#include "Depop.h"
#include "Input.h"
#include "Output.h"
#include "Mix.h"

