﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

enum DepopState
{
    DepopState0 = 0, // volume ramped to 0
    DepopState1 = 1, // volume ramped to full
};

const int DepopRampDownDelta    = 0x7fff / SamplesPerFrameCount;
const int DepopRampUpDelta      = 0xffff / SamplesPerFrameCount;


class Depop
{

public:

    void Initialize();
    void Finalize();

    int16_t * ProcessFrame(void *pSamples, bool depop);

private:

    int16_t m_LastGoodSample;
    int32_t m_State;

    void RampDcOffsetDown(int16_t *pSamples);
    void RampVolumeUp(int16_t *pSamples);
};

