﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UartTestHost
{
    /// <summary>
    /// テストシナリオの設定値を集めた列挙体です。
    /// </summary>
    /// <remarks>
    /// ハンドシェイクにおいてターゲットと共有するテストパラメータ内で使用します。
    /// そのため、定義値とデータサイズは密にターゲット側テストプログラムの同名型と一致している必要があります。
    /// </remarks>
    public enum TestScenario : byte
    {
        /// <summary>
        /// 少量のデータをターゲット→ PC → ターゲットという経路でループバックする、
        /// もっとも基本的な送受信が機能していることのテスト
        /// </summary>
        ShortLoopback = 0x01,

        /// <summary>
        /// ターゲットがオーバーランエラーを検出できることのテスト（フロー制御オフ時）
        /// </summary>
        OverRunDetection = 0x02,

        /// <summary>
        /// 受信バッファ溢れを検出できることのテスト（フロー制御オフ時）
        /// </summary>
        OutOfBufferDetection = 0x03,

        /// <summary>
        /// フロー制御オンでターゲットが送信側になり、オーバーランが発生しないことのテスト
        /// </summary>
        SendWithFlowControl = 0x04,

        /// <summary>
        /// フロー制御オンでターゲットが受信側になり、オーバーランが発生しないことのテスト
        /// </summary>
        LazyReceiveWithFlowControl = 0x05,

        /// <summary>
        /// ターゲットが受信側になり、ポートイベントを使用してデータを受信するテスト
        /// (フロー制御オン)
        /// </summary>
        ReceiveUsingPortEvent = 0x06,

        /// <summary>
        /// ターゲットが送信側になり、ポートイベントを使用してデータの送信完了を確認するテスト
        /// (フロー制御オン)
        /// </summary>
        SendUsingPortEvent = 0x07,

        /// <summary>
        /// ターゲットが受信側になり、受信終了イベントを使用して受信完了を検知するテスト
        /// </summary>
        ReceiveUsingReceiveEndEvent = 0x08,

        /// <summary>
        /// 全テストパターンの終了を意味する特別な値です。
        /// この値に対応して実行されるテストケースはありません。
        /// </summary>
        TestTermination = 0xff
    }
}
