﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UartTestHost
{
    /// <summary>
    /// プログラムのメイン関数用のクラス。
    /// </summary>
    public class Program
    {
        /// <summary>
        /// メイン関数です
        /// </summary>
        /// <param name="args">プログラムの起動引数</param>
        /// <returns>テスト結果</returns>
        public static int Main(string[] args)
        {
            TestResult result = TestResult.Success; // 0 で PASS
            bool toBeContinued = true;

            if (!CmdlineOption.Parse(args))
            {
                // ヘルプ表示時などの場合はここで中断
                return 0;
            }

            Console.WriteLine("Uart Test Host: Begin");

            while (toBeContinued)
            {
                result = TestBody.RunTest(out toBeContinued);
                if (result != TestResult.Success)
                {
                    toBeContinued = false; // 終了
                }
            }

            Console.WriteLine("Uart Test Host: End");

            return (int)result;
        }
    }
}
