﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunnerTest.TestStatementInfoTest
{
    using System;
    using System.Collections.Generic;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using TestRunner;

    /// <summary>
    /// [TestRunner.TestStatementInfo]::IsNoEntries用のテスト関数を定義します。
    /// </summary>
    [TestClass]
    public class IsNoEntriesTest
    {
        /// <summary>
        /// 境界値分析: ステートメント中の Tests 要素の型が有効なシーケンスノードでない
        /// </summary>
        [TestMethod]
        public void IsNoEntriesBoundaryTest001()
        {
            var key = "Tests";

            var node = new Dictionary<string, object>();

            Assert.IsTrue(new TestStatementInfo(node).IsNoEntries());

            node[key] = new object();

            Assert.IsTrue(new TestStatementInfo(node).IsNoEntries());

            node[key] = new List<object>();

            Assert.IsTrue(new TestStatementInfo(node).IsNoEntries());

            ((List<object>)node[key]).Add(new Dictionary<string, object>());

            Assert.IsFalse(new TestStatementInfo(node).IsNoEntries());
        }
    }
}
