﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.ServiceFramework;

namespace Nintendo.ServiceFrameworkTest
{
    [TestClass]
    public class SfNnBufferTest
    {
        public struct S
        {
            public int A;
        }

        [TestMethod]
        public void TestCanAccept()
        {
            Assert.IsTrue(SfNnBuffer.CanAccept(typeof(nn.sf.InBuffer)));
            Assert.IsTrue(SfNnBuffer.CanAccept(typeof(nn.sf.OutBuffer)));
            Assert.IsTrue(SfNnBuffer.CanAccept(typeof(nn.sf.InArray<int>)));
            Assert.IsTrue(SfNnBuffer.CanAccept(typeof(nn.sf.InArray<S>)));
            Assert.IsTrue(SfNnBuffer.CanAccept(typeof(nn.sf.OutArray<int>)));
            Assert.IsTrue(SfNnBuffer.CanAccept(typeof(nn.sf.OutArray<S>)));
        }

        [TestMethod]
        public void TestGetEntity()
        {
            // 共通テスト
            SfEntityTestUtility.TestGetEntityCommon<nn.sf.InBuffer, nn.sf.OutBuffer>();
            // エンティティの型が SfNnBuffer であることテスト
            var e = typeof(nn.sf.InBuffer).GetSfEntity();
            Assert.AreSame(typeof(SfNnBuffer), e.GetType());
        }

        [TestMethod]
        public void TestGetReferredTypesForBuffer()
        {
            var e = typeof(nn.sf.InBuffer).GetSfEntity();
            Assert.AreEqual(0, e.GetReferredEntities().Count());
            Assert.AreEqual(0, e.GetStronglyReferredEntities().Count());
        }

        [TestMethod]
        public void TestGetReferredTypesForArray()
        {
            var e = typeof(nn.sf.InArray<S>).GetSfEntity();
            AssertionUtility.AssertAreSetEqual(new[] { typeof(S).GetSfEntity() }, e.GetReferredEntities());
            AssertionUtility.AssertAreSetEqual(new[] { typeof(S).GetSfEntity() }, e.GetStronglyReferredEntities());
        }
    }
}
