﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.ServiceFramework;

namespace Nintendo.ServiceFrameworkTest
{
    [TestClass]
    public class SfBuiltInTest
    {
        [TestMethod]
        public void TestCanAccept()
        {
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(sbyte)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(byte)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(short)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(ushort)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(int)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(uint)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(long)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(ulong)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(bool)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(float)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(double)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(char_t)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(char16_t)));
            Assert.IsTrue(SfBuiltIn.CanAccept(typeof(char32_t)));
        }

        [TestMethod]
        public void TestGetEntity()
        {
            // 共通テスト
            SfEntityTestUtility.TestGetEntityCommon<int, float>();
            // エンティティの型が SfBuiltIn であることテスト
            var e = typeof(int).GetSfEntity();
            Assert.AreSame(typeof(SfBuiltIn), e.GetType());
        }

        [TestMethod]
        public void TestGetReferredTypes()
        {
            var e = typeof(int).GetSfEntity();
            Assert.AreEqual(0, e.GetReferredEntities().Count());
            Assert.AreEqual(0, e.GetStronglyReferredEntities().Count());
        }

        [TestMethod]
        public void TestSizeAndAlignment()
        {
            SfEntityTestUtility.TestSizeAndAlignment(1, 1, typeof(sbyte));
            SfEntityTestUtility.TestSizeAndAlignment(1, 1, typeof(byte));
            SfEntityTestUtility.TestSizeAndAlignment(2, 2, typeof(short));
            SfEntityTestUtility.TestSizeAndAlignment(2, 2, typeof(ushort));
            SfEntityTestUtility.TestSizeAndAlignment(4, 4, typeof(int));
            SfEntityTestUtility.TestSizeAndAlignment(4, 4, typeof(uint));
            SfEntityTestUtility.TestSizeAndAlignment(8, 8, typeof(long));
            SfEntityTestUtility.TestSizeAndAlignment(8, 8, typeof(ulong));
            SfEntityTestUtility.TestSizeAndAlignment(1, 1, typeof(bool));
            SfEntityTestUtility.TestSizeAndAlignment(4, 4, typeof(float));
            SfEntityTestUtility.TestSizeAndAlignment(8, 8, typeof(double));
            SfEntityTestUtility.TestSizeAndAlignment(1, 1, typeof(char_t));
            SfEntityTestUtility.TestSizeAndAlignment(2, 2, typeof(char16_t));
            SfEntityTestUtility.TestSizeAndAlignment(4, 4, typeof(char32_t));
        }
    }
}
