﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    using Nintendo.ServiceFramework;
    using Nintendo.ServiceFramework.CppCode;

    [TestClass]
    public class EntityCppCodeEmitterUtilityTest
    {
        #region TestGetParameterStringList

        private interface ITestGetParameterStringList
        {
            void F(nn.sf.InBuffer buffer);
        }

        [TestMethod]
        public void TestGetParameterStringList()
        {
            var f = typeof(ITestGetParameterStringList).GetMethod("F");
            var t = typeof(nn.sf.InBuffer);
            Assert.AreEqual("buffer", f.GetParameterStringList(false, false).ToArray()[0]);
            Assert.AreEqual("buffer", f.GetParameterStringList(false, true).ToArray()[0]);
            Assert.AreEqual("const ::nn::sf::InBuffer& buffer", f.GetParameterStringList(true, false).ToArray()[0]);
            Assert.AreEqual("const nn::sf::InBuffer& buffer", f.GetParameterStringList(true, true).ToArray()[0]);
        }

        #endregion

        #region TestGetMacroFunctionString

        [AttributeUsage(AttributeTargets.Method)]
        private class TestGetMacroFunctionStringAttribute : Attribute
        {
            public string Expected { get; private set; }
            public TestGetMacroFunctionStringAttribute(string expected)
            {
                this.Expected = expected;
            }
        }

        private interface ITestGetMacroFunctionString
        {
            [TestGetMacroFunctionString("_VOID_0(Void0)")]
            void Void0();

            [TestGetMacroFunctionString("_RESULT_0(Result0)")]
            nn.Result Result0();

            [TestGetMacroFunctionString("_VALUE_0(Value0, (float))")]
            float Value0();

            [TestGetMacroFunctionString("_VOID_N(Void1, (float x))")]
            void Void1(float x);

            [TestGetMacroFunctionString("_RESULT_N(Result1, (float x))")]
            nn.Result Result1(float x);

            [TestGetMacroFunctionString("_VALUE_N(Value1, (float), (float x))")]
            float Value1(float x);
        }

        [TestMethod]
        public void TestGetMacroFunctionString()
        {
            foreach (var method in typeof(ITestGetMacroFunctionString).GetMethods())
            {
                var expected = string.Format("PREFIX" + method.GetCustomAttribute<TestGetMacroFunctionStringAttribute>().Expected + "POSTFIX");
                Assert.AreEqual(expected, method.GetMacroFunctionString("PREFIX", true, true, "POSTFIX"));
            }
        }

        #endregion

        #region TestGetReturnTypeString

        private interface ITestGetReturnTypeString
        {
            void Void();
            nn.Result Result();
        }

        [TestMethod]
        public void TestGetReturnTypeString()
        {
            var t = typeof(ITestGetReturnTypeString);
            var methodVoid = t.GetMethod("Void");
            var methodResult = t.GetMethod("Result");
            Assert.AreEqual("void", methodVoid.GetReturnTypeString(false));
            Assert.AreEqual("void", methodVoid.GetReturnTypeString(true));
            Assert.AreEqual("::nn::Result", methodResult.GetReturnTypeString(false));
            Assert.AreEqual("nn::Result", methodResult.GetReturnTypeString(true));
        }

        #endregion
    }
}
