﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    using Nintendo.ServiceFramework;
    using Nintendo.ServiceFramework.CppCode;

    [TestClass]
    public class CppCodeGeneratorTest
    {
        private static void AssertGenerated(IEnumerable<Type> types, string expected)
        {
            GenerateTestUtility.AssertGeneratedString(g =>
            {
                new CppCodeGenerator().Generate(g, types.Select(SfEntityGetter.GetSfEntity).ToArray());
            }, expected);
        }

        [CppRefPath(@"<nnt/foo/IFoo.h>")]
        [CppFullName(@"nnt::foo::IFoo")]
        [UseCmif(false)]
        [UseImpl(false)]
        private interface IFoo : nn.sf.IServiceObject
        {
            [MethodId(0)]
            void A();
        }

        [CppRefPath(@"<nnt/foo/IFoo.h>")]
        [CppFullName(@"nnt::foo::IFoo2")]
        [UseCmif(false)]
        [UseImpl(false)]
        private interface IFoo2 : nn.sf.IServiceObject
        {
            [MethodId(0)]
            void A(int x);
        }

        [CppRefPath(@"<nnt/bar/IBar.h>")]
        [CppFullName(@"nnt::bar::IBar")]
        [UseCmif(false)]
        [UseImpl(false)]
        private interface IBar : nn.sf.IServiceObject
        {
            [MethodId(0)]
            void B(int x);
        }

        [TestMethod]
        public void TestZeroInterface()
        {
            AssertGenerated(Enumerable.Empty<Type>(), string.Empty);
        }

        [TestMethod]
        public void TestOneInterface()
        {
            AssertGenerated(new[] { typeof(IFoo) }, @"#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>

namespace nnt { namespace foo {

class IFoo;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFoo, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFoo)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(A)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFoo)

        void A() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(A);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFoo
    {
    public:
        void A() NN_NOEXCEPT;
    };
#endif

}}
");
            AssertGenerated(new[] { typeof(IBar) }, @"#include <cstdint>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>

namespace nnt { namespace bar {

class IBar;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBar, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBar)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(B, (::std::int32_t x))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBar)

        void B(::std::int32_t x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(B, (x));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBar
    {
    public:
        void B(std::int32_t x) NN_NOEXCEPT;
    };
#endif

}}
");
        }

        [TestMethod]
        public void TestTwoInterfaces()
        {
            AssertGenerated(new[] { typeof(IFoo), typeof(IFoo2) }, @"#include <cstdint>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>

namespace nnt { namespace foo {

class IFoo;

class IFoo2;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFoo, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFoo)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(A)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFoo)

        void A() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(A);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFoo
    {
    public:
        void A() NN_NOEXCEPT;
    };
#endif

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFoo2, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFoo2)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(A, (::std::int32_t x))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFoo2)

        void A(::std::int32_t x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(A, (x));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFoo2
    {
    public:
        void A(std::int32_t x) NN_NOEXCEPT;
    };
#endif

}}
");
            AssertGenerated(new[] { typeof(IFoo), typeof(IBar) }, @"#include <cstdint>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>

namespace nnt { namespace bar {

class IBar;

}}

namespace nnt { namespace foo {

class IFoo;

}}

namespace nnt { namespace bar {

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBar, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBar)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(B, (::std::int32_t x))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBar)

        void B(::std::int32_t x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(B, (x));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBar
    {
    public:
        void B(std::int32_t x) NN_NOEXCEPT;
    };
#endif

}}

namespace nnt { namespace foo {

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFoo, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFoo)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(A)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFoo)

        void A() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(A);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFoo
    {
    public:
        void A() NN_NOEXCEPT;
    };
#endif

}}
");
            AssertGenerated(new[] { typeof(IBar), typeof(IFoo) }, @"#include <cstdint>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>

namespace nnt { namespace bar {

class IBar;

}}

namespace nnt { namespace foo {

class IFoo;

}}

namespace nnt { namespace bar {

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBar, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBar)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(B, (::std::int32_t x))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBar)

        void B(::std::int32_t x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(B, (x));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBar
    {
    public:
        void B(std::int32_t x) NN_NOEXCEPT;
    };
#endif

}}

namespace nnt { namespace foo {

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFoo, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFoo)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(A)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFoo)

        void A() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(A);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFoo
    {
    public:
        void A() NN_NOEXCEPT;
    };
#endif

}}
");
        }

        [CppRefPath(@"<nnt/LittleStruct.h>")]
        [CppFullName(@"nnt::LittleStruct")]
        public struct LittleStruct
        {
            public int A;
        }

        [CppRefPath(@"<nnt/BigStruct.h>")]
        [CppFullName(@"nnt::BigStruct")]
        public struct BigStruct
        {
            public long A;
            public int B;
            public LittleStruct C;
        }

        [TestMethod]
        public void TestOneStruct()
        {
            AssertGenerated(new[] { typeof(LittleStruct) }, @"#include <cstdint>

namespace nnt {

struct LittleStruct;

struct LittleStruct
{
    std::int32_t A;
};

}
");
        }

        [TestMethod]
        public void TestTwoStruct()
        {
            AssertGenerated(new[] { typeof(BigStruct), typeof(LittleStruct) }, @"#include <cstdint>

namespace nnt {

struct BigStruct;

struct LittleStruct;

struct LittleStruct
{
    std::int32_t A;
};

struct BigStruct
{
    std::int64_t A;
    std::int32_t B;
    nnt::LittleStruct C;
};

}
");
        }

        [CppRefPath(@"<nnt/IStructInterface.h>")]
        [CppFullName(@"nnt::IStructInterface")]
        [UseCmif(false)]
        [UseImpl(false)]
        private interface IStructInterface : nn.sf.IServiceObject
        {
            [MethodId(0)]
            LittleStruct F(LittleStruct s, nn.sf.Out<LittleStruct> o);
            [MethodId(1)]
            BigStruct G(BigStruct s, nn.sf.Out<BigStruct> o);
        }

        [TestMethod]
        public void TestStructAndInterface()
        {
            AssertGenerated(new[] { typeof(IStructInterface) }, @"#include <nnt/BigStruct.h>
#include <nnt/LittleStruct.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>

namespace nnt {

class IStructInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IStructInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IStructInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(F, (::nnt::LittleStruct), (::nnt::LittleStruct s, ::nn::sf::Out<::nnt::LittleStruct> o))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(G, (::nnt::BigStruct), (const ::nnt::BigStruct& s, ::nn::sf::Out<::nnt::BigStruct> o))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IStructInterface)

        ::nnt::LittleStruct F(::nnt::LittleStruct s, ::nn::sf::Out<::nnt::LittleStruct> o) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(F, (::nnt::LittleStruct), (s, o));
        }

        ::nnt::BigStruct G(const ::nnt::BigStruct& s, ::nn::sf::Out<::nnt::BigStruct> o) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(G, (::nnt::BigStruct), (s, o));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IStructInterface
    {
    public:
        nnt::LittleStruct F(nnt::LittleStruct s, nn::sf::Out<nnt::LittleStruct> o) NN_NOEXCEPT;
        nnt::BigStruct G(const nnt::BigStruct& s, nn::sf::Out<nnt::BigStruct> o) NN_NOEXCEPT;
    };
#endif

}
");
            AssertGenerated(new[] { typeof(IStructInterface), typeof(BigStruct), typeof(LittleStruct) }, @"#include <cstdint>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>

namespace nnt {

struct BigStruct;

class IStructInterface;

struct LittleStruct;

struct LittleStruct
{
    std::int32_t A;
};

struct BigStruct
{
    std::int64_t A;
    std::int32_t B;
    nnt::LittleStruct C;
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IStructInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IStructInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(F, (::nnt::LittleStruct), (::nnt::LittleStruct s, ::nn::sf::Out<::nnt::LittleStruct> o))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(G, (::nnt::BigStruct), (const ::nnt::BigStruct& s, ::nn::sf::Out<::nnt::BigStruct> o))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IStructInterface)

        ::nnt::LittleStruct F(::nnt::LittleStruct s, ::nn::sf::Out<::nnt::LittleStruct> o) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(F, (::nnt::LittleStruct), (s, o));
        }

        ::nnt::BigStruct G(const ::nnt::BigStruct& s, ::nn::sf::Out<::nnt::BigStruct> o) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(G, (::nnt::BigStruct), (s, o));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IStructInterface
    {
    public:
        nnt::LittleStruct F(nnt::LittleStruct s, nn::sf::Out<nnt::LittleStruct> o) NN_NOEXCEPT;
        nnt::BigStruct G(const nnt::BigStruct& s, nn::sf::Out<nnt::BigStruct> o) NN_NOEXCEPT;
    };
#endif

}
");
        }
    }
}
