﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.ServiceFramework.CppCode;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    [TestClass]
    public class AttributesTest
    {
        #region CppFullNameAttribute

        internal interface INoCppFullNameInterface
        {
        }

        private const string TestFullName = @"nn::sfsmpl::ISfSample";

        [CppFullName(TestFullName)]
        internal interface ICppFullNameInterface
        {
        }

        [TestMethod]
        public void TestCppFullNameAttribute()
        {
            Assert.AreEqual("Nintendo::ServiceFrameworkTest::CppCode::AttributesTest::INoCppFullNameInterface", CppFullNameAttribute.GetCppFullName(typeof(INoCppFullNameInterface)));
            Assert.AreEqual(TestFullName, CppFullNameAttribute.GetCppFullName(typeof(ICppFullNameInterface)));
        }

        #endregion

        #region CppRefPathAttribute

        internal interface INoCppRefPathInterface
        {
        }

        [CppRefPath(null)]
        internal interface INullCppRefPathInterface
        {
        }

        private const string TestPath = @"<nn/sf.h>";
        private const string TestPath2 = @"<nn/fs.h>";

        [CppRefPath(TestPath)]
        internal interface ICppRefPathInterface
        {
        }

        [CppRefPath(TestPath)]
        [CppRefPath(TestPath2)]
        internal interface ICppRefPathInterface2
        {
        }

        [TestMethod]
        public void TestCppRefPathAttribute()
        {
            Assert.AreEqual(0, CppRefPathAttribute.GetCppRefPaths(typeof(INoCppRefPathInterface)).Count());
            Assert.AreEqual(null, CppRefPathAttribute.GetCppRefPaths(typeof(INullCppRefPathInterface)).Single());
            Assert.AreEqual(TestPath, CppRefPathAttribute.GetCppRefPaths(typeof(ICppRefPathInterface)).Single());
            var a = CppRefPathAttribute.GetCppRefPaths(typeof(ICppRefPathInterface2)).ToArray();
            Assert.AreEqual(2, a.Length);
            Assert.AreEqual(a[0], TestPath);
            Assert.AreEqual(a[1], TestPath2);
        }

        #endregion
    }
}
