﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.ControlTarget;
using Nintendo.RunOnTarget;
using System.IO;
using System.IO.Ports;
using System.Diagnostics;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Threading.Tasks.Dataflow;
using TestUtility;

namespace RunnerToolsTest
{
    [TestClass]
    public class ControlTargetTest
    {
        [TestMethod]
        public void TestListCommand()
        {
            Assert.AreEqual(@"<?xml version=""1.0"" encoding=""utf-8""?>
<TargetList>
  <Target>
    <Name>40-D2-8A-B4-73-4B</Name>
    <Hardware>SDEV_00_01_05</Hardware>
    <Connection>Host Bridge</Connection>
    <SerialNumber>XAWF0111100014</SerialNumber>
    <IPAddress>192.168.0.1</IPAddress>
    <Status>Connected</Status>
  </Target>
</TargetList>",
                ListTargetCommand.ListTargetAsXml());
        }

        [TestMethod]
        public void TestDetectCommand()
        {
            Assert.AreEqual(@"<?xml version=""1.0"" encoding=""utf-8""?>
<TargetList>
  <Target>
    <Name>40-D2-8A-B4-73-4B</Name>
    <Hardware>Unknown</Hardware>
    <Connection>Host Bridge</Connection>
    <SerialNumber>Unknown</SerialNumber>
    <IPAddress>192.168.0.1</IPAddress>
    <Status>Unknown</Status>
  </Target>
</TargetList>",
                ListTargetCommand.DetectTargetAsXml(TimeSpan.FromSeconds(5)));
        }

        [TestMethod]
        public void TestListCommandAsCsv()
        {
            Assert.AreEqual(@"""Name"",""Hardware"",""Connection"",""SerialNumber"",""IPAddress"",""Status""
""40-D2-8A-B4-73-4B"",""SDEV_00_01_05"",""HBX"",""XAWF0111100014"",""192.168.0.1"",""Connected""
",
                ListTargetCommand.ListTargetAsCsv());
        }

        [TestMethod]
        public void TestDetectCommandAsCsv()
        {
            Assert.AreEqual(@"""Name"",""Hardware"",""Connection"",""SerialNumber"",""IPAddress"",""Status""
""40-D2-8A-B4-73-4B"",""Unknown"",""HBX"",""Unknown"",""192.168.0.1"",""Unknown""
",
                ListTargetCommand.DetectTargetAsCsv(TimeSpan.FromSeconds(5)));
        }
    }
}
