﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;
using System.Collections.Generic;
using System.IO;
using TestUtility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace MakeMetaTest
{
    public class TestDataForKc
    {
        // No.3
        public static XmlElement MakeThreadInfoElement(string lowestPriority, string highestPriority, string minCore, string maxCore)
        {
            XmlElement threadInfo = new XmlElement("ThreadInfo");

            if (lowestPriority != null)
            {
                XmlElement lowestPriorityElem = new XmlElement("LowestPriority");
                threadInfo.AddChild(lowestPriorityElem);
                lowestPriorityElem.InnerText = lowestPriority;
            }

            if (highestPriority != null)
            {
                XmlElement highestPriorityElem = new XmlElement("HighestPriority");
                threadInfo.AddChild(highestPriorityElem);
                highestPriorityElem.InnerText = highestPriority;
            }

            if (minCore != null)
            {
                XmlElement minCoreNumberElem = new XmlElement("MinCoreNumber");
                threadInfo.AddChild(minCoreNumberElem);
                minCoreNumberElem.InnerText = minCore;
            }

            if (maxCore != null)
            {
                XmlElement maxCoreNumberElem = new XmlElement("MaxCoreNumber");
                threadInfo.AddChild(maxCoreNumberElem);
                maxCoreNumberElem.InnerText = maxCore;
            }

            return threadInfo;
        }

        // No.4
        public static XmlElement MakeEnableSystemCall(string systemCall)
        {
            XmlElement syscallElem = new XmlElement("EnableSystemCalls");
            syscallElem.InnerText = systemCall;
            return syscallElem;
        }

        public static XmlElement[] MakeEnableSystemCalls(string[] systemCalls)
        {
            XmlElement[] syscallElems = new XmlElement[systemCalls.Length];
            for (int i = 0; i < systemCalls.Length; i++)
            {
                syscallElems[i] = MakeEnableSystemCall(systemCalls[i]);
            }
            return syscallElems;
        }

        public static XmlElement MakeEnableSystemCallClass(string systemCall, string id)
        {
            XmlElement syscallElem = new XmlElement("EnableSystemCalls");

            XmlElement name = new XmlElement("Name");
            name.InnerText = systemCall;
            syscallElem.AddChild(name);

            XmlElement svcId = new XmlElement("SystemCallId");
            svcId.InnerText = id;
            syscallElem.AddChild(svcId);

            return syscallElem;
        }

        public static XmlElement[] MakeEnableSystemCallClasses(string[] systemCalls, string[] ids)
        {
            XmlElement[] syscallElems = new XmlElement[systemCalls.Length];
            for (int i = 0; i < systemCalls.Length; i++)
            {
                syscallElems[i] = MakeEnableSystemCallClass(systemCalls[i], ids[i]);
            }
            return syscallElems;
        }


        // No. 6, 7
        public static XmlElement MakeMemoryMap(string beginAddress, string size, string permission, string type)
        {
            XmlElement mapElem = new XmlElement("MemoryMap");

            if (beginAddress != null)
            {
                XmlElement beginAddrElem = new XmlElement("BeginAddress");
                beginAddrElem.InnerText = beginAddress;
                mapElem.AddChild(beginAddrElem);
            }

            if (size != null)
            {
                XmlElement sizeElem = new XmlElement("Size");
                sizeElem.InnerText = size;
                mapElem.AddChild(sizeElem);
            }

            if (permission != null)
            {
                XmlElement permissionElem = new XmlElement("Permission");
                permissionElem.InnerText = permission;
                mapElem.AddChild(permissionElem);
            }

            if (type != null)
            {
                XmlElement typeElem = new XmlElement("Type");
                typeElem.InnerText = type;
                mapElem.AddChild(typeElem);
            }

            return mapElem;
        }

        // No. 11
        public static XmlElement MakeEnableInterrupt(string interrupt)
        {
            XmlElement interruptElem = new XmlElement("EnableInterrupts");
            interruptElem.InnerText = interrupt;
            return interruptElem;
        }

        public static XmlElement[] MakeEnableInterrupts(string[] interrupts)
        {
            XmlElement[] interruptElems = new XmlElement[interrupts.Length];
            for (int i = 0; i < interrupts.Length; i++)
            {
                interruptElems[i] = MakeEnableInterrupt(interrupts[i]);
            }
            return interruptElems;
        }

        // No. 13
        public static XmlElement MakeMiscParams(string programType)
        {
            XmlElement entry = new XmlElement("MiscParams");
            if (programType != null)
            {
                XmlElement programTypesElem = new XmlElement("ProgramType");
                programTypesElem.InnerText = programType;
                entry.AddChild(programTypesElem);
            }

            return entry;
        }

        // No. 14
        public static XmlElement MakeKernelVersion(string major, string minor)
        {
            XmlElement entry = new XmlElement("KernelVersion");
            if (major != null)
            {
                XmlElement majorEntry = new XmlElement("MajorVersion");
                majorEntry.InnerText = major;
                entry.AddChild(majorEntry);
            }
            if (minor != null)
            {
                XmlElement minorEntry = new XmlElement("MinorVersion");
                minorEntry.InnerText = minor;
                entry.AddChild(minorEntry);
            }

            return entry;
        }

        // No. 15
        public static XmlElement MakeHandleTableSize(string tableSize)
        {
            XmlElement tableElem = new XmlElement("HandleTableSize");
            tableElem.InnerText = tableSize;
            return tableElem;
        }

        // No. 16
        public static XmlElement MakeMiscFlags(string enableDebug, string forceDebug)
        {
            XmlElement miscFlagsElem = new XmlElement("MiscFlags");

            if (enableDebug != null)
            {
                XmlElement enableElem = new XmlElement("EnableDebug");
                enableElem.InnerText = enableDebug;
                miscFlagsElem.AddChild(enableElem);
            }

            if (forceDebug != null)
            {
                XmlElement forceElem = new XmlElement("ForceDebug");
                forceElem.InnerText = forceDebug;
                miscFlagsElem.AddChild(forceElem);
            }

            return miscFlagsElem;
        }
    }
}
