﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.HtcTools.Htclow;

namespace Nintendo.HtcTools.Htclow
{
    [TestClass]
    public class PacketTest
    {
        [TestMethod]
        public void PacketConstruction()
        {
            var packet = new Packet(8)
            {
                PacketType = PacketType.Syn,
                Channel = new Channel() { ModuleId = 0x05, ChannelId = 0x0403 },
                SequenceId = 0x1817161514131211,
            };

            packet.SetBody(new byte[]
            {
                0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
            });

            var expected = new byte[]
            {
                // Protocol
                0x00, 0x01,
                // Version
                0x00, 0x00,
                // Reserved
                0x00, 0x00,
                // PacketType
                0x02, 0x00,
                // Channel
                0x03, 0x04, 0x00, 0x05,
                // BodySize
                0x08, 0x00, 0x00, 0x00,
                // SequenceId
                0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
                // Body
                0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
            };
            CollectionAssert.AreEqual(expected, packet.GetBytes());
        }
    }
}
