﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using GitExternalRepository;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Microsoft.Win32;
using System.Collections.Generic;
using System.Linq;
using GitExternalRepository.Configs;
using GitExternalRepository.Commands;
using GitExternalRepository.Consoles;

namespace GitExternalRepositoryTest.Commands
{
    [TestClass]
    public class UnitTestCommandFactory
    {
        /// <summary>
        /// Defines メソッドを試します。
        /// </summary>
        [TestMethod]
        public void TestDefines()
        {
            var factory = new CommandFactory();

            Assert.IsTrue(factory.Defines(typeof(AddCommand.Parameters)));
            Assert.IsTrue(factory.Defines(typeof(InitCommand.Parameters)));
            Assert.IsFalse(factory.Defines(typeof(object)));
        }

        /// <summary>
        /// Create メソッドを試します。
        /// </summary>
        [TestMethod]
        public void TestCreate()
        {
            var factory = new CommandFactory();

            var addCommand = factory.Create(typeof(AddCommand.Parameters), new StandardStreamConsole());
            Assert.AreEqual(typeof(AddCommand), addCommand.GetType());

            var initCommand = factory.Create(typeof(InitCommand.Parameters), new StandardStreamConsole());
            Assert.AreEqual(typeof(InitCommand), initCommand.GetType());

            var updateCommand = factory.Create(typeof(UpdateCommand.Parameters), new StandardStreamConsole());
            Assert.AreEqual(typeof(UpdateCommand), updateCommand.GetType());

            var updateReferenceCommand = factory.Create(typeof(UpdateReferenceCommand.Parameters), new StandardStreamConsole());
            Assert.AreEqual(typeof(UpdateReferenceCommand), updateReferenceCommand.GetType());
        }
    }
}
