﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using EffectMaker.Foundation.Render.Layout;
using EffectMaker.UIControls;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Layout;
using EffectMaker.UIControls.SpecificControls;
using EffectMaker.UIControls.ValueConverters;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.EffectMaker.UIControls.TestTypes;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// Test class that contains the ItemsControl test methods.
    /// </summary>
    [TestClass]
    public class ItemsControlUnitTests
    {
        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl01()
        {
            var itemsControl = new UIItemsControl();
            itemsControl.ItemContainerType = typeof(TestLabel);

            itemsControl.ItemsSource = new[] { 0, 1, 2, 3 };

            if (itemsControl.Controls.Count != 4)
            {
                throw new Exception();
            }

            if (((Control)itemsControl.Controls[2]).Text != "2")
            {
                throw new Exception();
            }

            itemsControl.ItemsSource = new[] { "A", "B", "C" };

            if (itemsControl.Controls.Count != 3)
            {
                throw new Exception();
            }

            if (((Control)itemsControl.Controls[1]).Text != "B")
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl02()
        {
            var treeview = new TestTreeView();

            treeview.ItemsSource = new object[]
            {
                new
                {
                    Value = "Root",
                    Items = new object[]
                    {
                        new
                        {
                            Value = "A",
                            Items = new object[]
                            {
                                new { Value = "a1" },
                                new { Value = "a2" },
                                new { Value = "a3" },
                            }
                        },
                        new
                        {
                            Value = "B",
                            Items = new object[]
                            {
                                new { Value = "b1" },
                                new { Value = "b2" },
                                new { Value = "b3" },
                            }
                        },
                        new
                        {
                            Value = "C",
                            Items = new object[]
                            {
                                new { Value = "c1" },
                                new { Value = "c2" },
                                new { Value = "c3" },
                            }
                        },
                    }
                },
            };

            if (treeview.Nodes.Count != 1)
            {
                throw new Exception();
            }

            var rootNode = treeview.Children[0];

            if (((TreeNode)rootNode).Text != "Root")
            {
                throw new Exception();
            }

            if (rootNode.Children.Count != 3)
            {
                throw new Exception();
            }

            var a = rootNode.Children[0];
            var b = rootNode.Children[1];
            var c = rootNode.Children[2];

            if (((TreeNode)a).Text != "A" ||
                ((TreeNode)b).Text != "B" ||
                ((TreeNode)c).Text != "C")
            {
                throw new Exception();
            }

            if (a.Children.Count != 3 || b.Children.Count != 3 || c.Children.Count != 3)
            {
                throw new Exception();
            }

            var a1 = a.Children[0];
            var a2 = a.Children[1];
            var a3 = a.Children[2];

            var b1 = b.Children[0];
            var b2 = b.Children[1];
            var b3 = b.Children[2];

            var c1 = c.Children[0];
            var c2 = c.Children[1];
            var c3 = c.Children[2];

            if (((TreeNode)a1).Text != "a1" ||
                ((TreeNode)a2).Text != "a2" ||
                ((TreeNode)a3).Text != "a3")
            {
                throw new Exception();
            }

            if (((TreeNode)b1).Text != "b1" ||
                ((TreeNode)b2).Text != "b2" ||
                ((TreeNode)b3).Text != "b3")
            {
                throw new Exception();
            }

            if (((TreeNode)c1).Text != "c1" ||
                ((TreeNode)c2).Text != "c2" ||
                ((TreeNode)c3).Text != "c3")
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl03()
        {
            var treeview = new TestTreeView();

            treeview.ItemsSource = new object[]
            {
                new { Value = "Root" },
            };

            if (treeview.Controls.Count != 1)
            {
                throw new Exception();
            }

            var rootNode = treeview.Children[0];

            if (((TreeNode)rootNode).Text != "Root")
            {
                throw new Exception();
            }

            if (rootNode.Children.Count != 0)
            {
                throw new Exception();
            }

            treeview.ItemsSource = null;

            if (treeview.Controls.Count != 0)
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl04()
        {
            var treeview = new TestTreeView();

            treeview.Nodes.Add(new TreeNode());

            if (treeview.Nodes.Count != 1)
            {
                throw new Exception();
            }

            treeview.ItemsSource = new object[]
            {
                new { Value = "Root1" },
                new { Value = "Root2" },
                new { Value = "Root3" },
            };

            if (treeview.Controls.Count != 3 ||
                treeview.Nodes.Count != 3)
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl05()
        {
            var itemsControl = new TestItemsControl();
            itemsControl.ItemContainerType = typeof(TestLabel);

            itemsControl.Controls.Add(new UIButton());

            if (itemsControl.Controls.Count != 1)
            {
                throw new Exception();
            }

            itemsControl.ItemsSource = new object[]
            {
                new { Value = "Root1" },
                new { Value = "Root2" },
                new { Value = "Root3" },
            };

            if (itemsControl.Controls.Count != 3)
            {
                throw new Exception();
            }

            var failed = false;

            try
            {
                itemsControl.Controls.Add(new UIButton());
            }
            catch
            {
                failed = true;
            }

            if (failed == false)
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl06()
        {
            var vm = new FullyObservableViewModel();

            var control = new UIItemsControl();
            control.ItemContainerType = typeof(TestLabel);

            control.ItemsSource = vm.Items;

            if (control.Controls.Count != 0)
            {
                throw new Exception();
            }

            vm.Items.Add(new FullyObservableViewModel());
            vm.Items.Add(new FullyObservableViewModel());
            vm.Items.Add(new FullyObservableViewModel());

            if (control.Controls.Count != 3)
            {
                throw new Exception();
            }

            vm.Items.Clear();

            if (control.Controls.Count != 0)
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl07()
        {
            var treeview = new TestTreeView();
            treeview.ItemContainerType = typeof(TestTreeNode2);

            treeview.ItemsSource = new object[]
            {
                new
                {
                    Value = "Root",
                    Items = new object[]
                    {
                        new
                        {
                            Value = "A",
                            Items = new object[]
                            {
                                new { Value = "a1" },
                                new { Value = "a2" },
                                new { Value = "a3" },
                            }
                        },
                        new
                        {
                            Value = "B",
                            Items = new object[]
                            {
                                new { Value = "b1" },
                                new { Value = "b2" },
                                new { Value = "b3" },
                            }
                        },
                        new
                        {
                            Value = "C",
                            Items = new object[]
                            {
                                new { Value = "c1" },
                                new { Value = "c2" },
                                new { Value = "c3" },
                            }
                        },
                    }
                },
            };

            if (treeview.Nodes.Count != 1)
            {
                throw new Exception();
            }

            var rootNode = treeview.Children[0];

            if (((TreeNode)rootNode).Text != "Root")
            {
                throw new Exception();
            }

            if (rootNode.Children.Count != 3)
            {
                throw new Exception();
            }

            var a = rootNode.Children[0];
            var b = rootNode.Children[1];
            var c = rootNode.Children[2];

            if (((TreeNode)a).Text != "A" ||
                ((TreeNode)b).Text != "B" ||
                ((TreeNode)c).Text != "C")
            {
                throw new Exception();
            }

            if (a.Children.Count != 3 || b.Children.Count != 3 || c.Children.Count != 3)
            {
                throw new Exception();
            }

            var a1 = a.Children[0];
            var a2 = a.Children[1];
            var a3 = a.Children[2];

            var b1 = b.Children[0];
            var b2 = b.Children[1];
            var b3 = b.Children[2];

            var c1 = c.Children[0];
            var c2 = c.Children[1];
            var c3 = c.Children[2];

            if (((TreeNode)a1).Text != "a1" ||
                ((TreeNode)a2).Text != "a2" ||
                ((TreeNode)a3).Text != "a3")
            {
                throw new Exception();
            }

            if (((TreeNode)b1).Text != "b1" ||
                ((TreeNode)b2).Text != "b2" ||
                ((TreeNode)b3).Text != "b3")
            {
                throw new Exception();
            }

            if (((TreeNode)c1).Text != "c1" ||
                ((TreeNode)c2).Text != "c2" ||
                ((TreeNode)c3).Text != "c3")
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl08()
        {
            var itemsControl = new UIItemsControl();
            itemsControl.ItemContainerType = typeof(TestButton);

            itemsControl.ItemsSource = new[]
            {
                "String A",
                "String B",
                "String C"
            };

            if (((TestButton)itemsControl.Controls[0]).Text != "String A" ||
                ((TestButton)itemsControl.Controls[1]).Text != "String B" ||
                ((TestButton)itemsControl.Controls[2]).Text != "String C")
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with ItemsControl.
        /// </summary>
        [TestMethod]
        public void TestItemsControl09()
        {
            var itemsControl = new UIItemsControl();
            itemsControl.ItemContainerSelector = new TestItemContainerSelector();

            var dateTime = DateTime.Now;

            itemsControl.ItemsSource = new object[]
            {
                "String A",
                dateTime,
                51
            };

            if ((itemsControl.Controls[0] is UILabel) == false ||
                ((UILabel)itemsControl.Controls[0]).Text != "String A")
            {
                throw new Exception();
            }

            if ((itemsControl.Controls[1] is UIDateTimePicker) == false ||
                ((UIDateTimePicker)itemsControl.Controls[1]).Value != dateTime)
            {
                throw new Exception();
            }

            if ((itemsControl.Controls[2] is UILabel) == false ||
                ((UILabel)itemsControl.Controls[2]).Text != "51")
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Test with Stackpanel.
        /// </summary>
        [TestMethod]
        public void TestItemsControlStackPanelLayout01()
        {
            const int PaddingValue = 5;
            const int MarginValue = 3;
            int panelWidth = 200;
            int panelHeight = 200;

            // setup
            var panel = new StackPanel();
            panel.Padding = new System.Windows.Forms.Padding(PaddingValue);
            panel.Width = panelWidth;
            panel.Height = panelHeight;

            Form f = new Form();
            f.Width = panelWidth;
            f.Height = panelHeight;
            f.Controls.Add(panel);

            // add controls into the stackpanel.
            var btn0 = new UIButton();
            var btn1 = new UIButton();
            var btn2 = new UIButton();
            var btn3 = new UIButton();
            UIButton[] btns = { btn0, btn1, btn2, btn3 };

            // Q:パディングにネガティブ値をセットしたら？
////        btn0.Margin = new Padding(-marginValue); // A: Allは-1に、その他は0にセットされる

            // 全体の一律設定
            foreach (var btn in btns)
            {
                panel.Controls.Add(btn);
                btn.Margin = new System.Windows.Forms.Padding(MarginValue);
                btn.AutoSize = true;
                btn.Text = "text";
                btn.Visibility = Visibility.Visible;
                btn.VerticalAlignment = VAlignment.Stretch;
            }

            // 個々のアイテムを設定
            btn0.HorizontalAlignment = HAlignment.Left;
            btn1.HorizontalAlignment = HAlignment.Center;
            btn2.HorizontalAlignment = HAlignment.Right;
            btn3.HorizontalAlignment = HAlignment.Stretch;

            for (int i = 0; i < 5; i++)
            {
                // 左側
                Assert.AreEqual(btn0.Location.X, MarginValue + PaddingValue, "Failed");

                // センターなので、誤差1pixelを許容する
                int x0 = (panelWidth / 2) - (btn1.Width / 2);
                Assert.IsTrue((btn1.Location.X < x0 + 1) || (btn1.Location.X > x0 - 1), "Failed");

                // 右側
                Assert.AreEqual(btn2.Location.X, panelWidth - (btn2.Width + MarginValue + PaddingValue), "Failed");

                // 利用可能なスペース全体
                Assert.AreEqual(btn3.Location.X, MarginValue + PaddingValue, "Failed");
                Assert.AreEqual(btn3.Width, panelWidth - ((MarginValue + PaddingValue) * 2), "Failed");

                // スタックパネルのサイズを小さくする
                panelWidth -= 11;
                panel.Width = panelWidth;
            }
        }

        /// <summary>
        /// スタックパネル：縦方向のテスト
        /// </summary>
        [TestMethod]
        public void TestItemsControlStackPanelLayoutVert()
        {
            const int Padding = 5;
            const int Margin = 3;
            int panelWidth = 200;
            int panelHeight = 200;

            // setup
            var panel = new StackPanel();
            panel.Padding = new Padding(Padding);
            panel.Width = panelWidth;
            panel.Height = panelHeight;

            Form f = new Form();
            f.Width = panelWidth;
            f.Height = panelHeight;
            f.Controls.Add(panel);

            // add controls into the stackpanel.
            var btn0 = new UIButton();
            var btn1 = new UIButton();
            var btn2 = new UIButton();
            var btn3 = new UIButton();
            UIButton[] btns = { btn0, btn1, btn2, btn3 };

            // 全体の一律設定
            foreach (var btn in btns)
            {
                panel.Controls.Add(btn);
                btn.Margin = new Padding(Margin);
                btn.AutoSize = true;
                btn.Text = "text";
                btn.Visibility = Visibility.Visible;
            }

            // 個々のアイテムを設定
            btn0.VerticalAlignment = VAlignment.Top;
            btn1.VerticalAlignment = VAlignment.Center;
            btn2.VerticalAlignment = VAlignment.Stretch;
            btn3.VerticalAlignment = VAlignment.Bottom;

            // 上
            Assert.AreEqual(btn0.Location.Y, Margin + Padding, "Failed");

            // センターなので、誤差1pixelを許容する
            int y0 = (panelHeight / 2) - (btn1.Height / 2);
            Assert.IsTrue((btn1.Location.Y < y0 + 1) || (btn1.Location.Y > y0 - 1), "Failed");

            /*
            // 残りの領域
            y0 = btn1.Location.Y+btn1.Height + MarginValue + PaddingValue;
            int y1 = btn3.Location.Y;
            Assert.AreEqual(btn2.Height, y1-y0, "Failed");

            // 下
            Assert.AreEqual(
                btn3.Location.Y,
                panelHeight - (btn3.Height + Margin + Padding),
                "Failed");

            btn3.Visibility = Visibility.Collapsed;
            */
        }
    }
}
