﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// Sample view model to test nested data contexts.
    /// </summary>
    public class SubViewModel1 : DummyViewModel
    {
        /// <summary>
        /// Backing field for the A property.
        /// </summary>
        private DummyViewModel a = new DummyViewModel();

        /// <summary>
        /// Backing field for the B property.
        /// </summary>
        private DummyViewModel b = new DummyViewModel();

        /// <summary>
        /// Backing field for the C property.
        /// </summary>
        private DummyViewModel c = new DummyViewModel();

        /// <summary>
        /// Backing field for the SubViewModel property.
        /// </summary>
        private SubViewModel2 subViewModel = new SubViewModel2();

        /// <summary>
        /// Gets or sets the A view model.
        /// </summary>
        public DummyViewModel A
        {
            get
            {
                return this.a;
            }

            set
            {
                this.SetValue(ref this.a, value);
            }
        }

        /// <summary>
        /// Gets or sets the B view model.
        /// </summary>
        public DummyViewModel B
        {
            get
            {
                return this.b;
            }

            set
            {
                this.SetValue(ref this.b, value);
            }
        }

        /// <summary>
        /// Gets or sets the C view model.
        /// </summary>
        public DummyViewModel C
        {
            get
            {
                return this.c;
            }

            set
            {
                this.SetValue(ref this.c, value);
            }
        }

        /// <summary>
        /// Gets or sets the sub view model.
        /// </summary>
        public SubViewModel2 SubViewModel
        {
            get
            {
                return this.subViewModel;
            }

            set
            {
                this.SetValue(ref this.subViewModel, value);
            }
        }
    }
}
