﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// Dummy data model
    /// </summary>
    public class DummyDataModel : DataModelBase
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        public DummyDataModel() :
            base()
        {
            this.BooleanValue  = true;
            this.IntegerValue  = 0;
            this.DateTimeValue = DateTime.Now;
            this.StringValue   = string.Empty;
            this.ObjectValue   = null;
        }

        /// <summary>
        /// Gets or sets a Boolean value.
        /// </summary>
        public bool BooleanValue { get; set; }

        /// <summary>
        /// Gets or sets an Integer value.
        /// </summary>
        public int IntegerValue { get; set; }

        /// <summary>
        /// Gets or sets a DateTime value.
        /// </summary>
        public DateTime DateTimeValue { get; set; }

        /// <summary>
        /// Gets or sets a String value.
        /// </summary>
        public string StringValue { get; set; }

        /// <summary>
        /// Gets or sets an Object value.
        /// </summary>
        public object ObjectValue { get; set; }

        /// <summary>
        /// Copy the source instance.
        /// </summary>
        /// <param name="src">Source instance to copy from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as DummyDataModel;
            if (srcDataModel == null)
            {
                return false;
            }

            this.BooleanValue  = srcDataModel.BooleanValue;
            this.IntegerValue  = srcDataModel.IntegerValue;
            this.DateTimeValue = srcDataModel.DateTimeValue;
            this.StringValue   = srcDataModel.StringValue;
            this.ObjectValue   = srcDataModel.ObjectValue;

            return true;
        }
    }
}
