﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reflection;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.EffectMaker.TextureManager.UnitTests
{
    using global::EffectMaker.Foundation.Texture;
    using global::EffectMaker.TextureManager;

    /// <summary>
    /// Contains unit tests related to the texture manager.
    /// </summary>
    [TestClass]
    public class TextureManagerUnitTests
    {
        /// <summary>
        /// Test the [?] functionalities.
        /// </summary>
        [TestMethod]
        public void TestLoadTexture()
        {
            TextureManager texManager = new TextureManager();
            string texPath = System.IO.Path.Combine(
                System.IO.Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location),
                "../../../../../../../Samples/Sources/Applications/G3dDemo/Resources/human/textures/human_A.ftxb");
            Assert.IsTrue(System.IO.File.Exists(texPath));
            var result = texManager.LoadTexture(texPath, false);
            Assert.AreEqual(LoadTextureResultCode.Success, result.ResultCode);
            Assert.IsNotNull(result.TextureData);
        }
    }
}
