﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.IO;
using System.Linq;
using EffectMaker.Foundation.Model;
using EffectMaker.Foundation.Model.Types;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.EffectMaker.PrimitiveManager.UnitTests
{
    /// <summary>
    /// プリミティブマネージャの単体テスト
    /// </summary>
    [TestClass]
    public class PrimitiveManagerUnitTests
    {
        /// <summary>
        /// シンプルな使い方テスト
        /// </summary>
        [TestMethod]
        public void SimpleTest()
        {
            var srcPath = Path.Combine(Environment.GetEnvironmentVariable("NW4F_ROOT"), @"SampleData\Effect\Primitives\Burn.fmdb");

            var primMan = new global::EffectMaker.PrimitiveManager.PrimitiveManager();
            Assert.IsTrue(primMan.CanLoad(srcPath));

            var result = primMan.LoadModel(srcPath);

            Assert.AreEqual(result.Result, LoadModelResults.Success);
            Assert.IsNotNull(result.ModelData);

            Assert.AreEqual(result.ModelData.Position.Count, 56);
            Assert.AreEqual(result.ModelData.Position.Column, 3);
            Assert.AreEqual(result.ModelData.Position.ElementData.Length, 168);
            Assert.AreEqual(result.ModelData.Position.ElementData[0], 0.366868168f);
            Assert.AreEqual(result.ModelData.Position.ElementData.Last(), -0.135011822f);

            Assert.AreEqual(result.ModelData.Color.Count, 56);
            Assert.AreEqual(result.ModelData.Color.Column, 4);
            Assert.AreEqual(result.ModelData.Color.ElementData.Length, 224);
            Assert.AreEqual(result.ModelData.Color.ElementData[0], 1.0f);
            Assert.AreEqual(result.ModelData.Color.ElementData.Last(), 0.0f);

            Assert.AreEqual(result.ModelData.TexCoord0.Count, 56);
            Assert.AreEqual(result.ModelData.TexCoord0.Column, 2);
            Assert.AreEqual(result.ModelData.TexCoord0.ElementData.Length, 112);
            Assert.AreEqual(result.ModelData.TexCoord0.ElementData[0], 0.59375f);
            Assert.AreEqual(result.ModelData.TexCoord0.ElementData.Last(), 0.6875);

            // 無いデータの振る舞い
            Assert.AreEqual(result.ModelData.TexCoord1.Count, 0);
            Assert.AreEqual(result.ModelData.TexCoord1.Column, 0);
            Assert.IsFalse(result.ModelData.TexCoord1.ElementData.Any());

            Assert.AreEqual(result.ModelData.Indexes.Indexes.Length, 120);
            Assert.AreEqual(result.ModelData.Indexes.Indexes[0], 0);
            Assert.AreEqual(result.ModelData.Indexes.Indexes[1], 1);
            Assert.AreEqual(result.ModelData.Indexes.Indexes[2], 2);
            Assert.AreEqual(result.ModelData.Indexes.Indexes[3], 0);
            Assert.AreEqual(result.ModelData.Indexes.Indexes[4], 3);
            Assert.AreEqual(result.ModelData.Indexes.Indexes[5], 1);
            Assert.AreEqual(result.ModelData.Indexes.Indexes.Last(), 55);

            Assert.AreEqual(result.ModelData.NumberOfTextures, 0);
        }
    }
}
