﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "effectdemo.h"

#include <nw/dev.h>
//#include <viewer/eftvw_ViewerSystem.h>
//#include <ut/eftut_PrimitiveRendererNw.h>
//#include <ut/eftut_TextWriter.h>

#include <eftdemo_System.h>
#include <eftdemo_ModelUtility.h>
#include <eftdemo_PerfomanceAnalyzer.h>
#include <G3dModelPreview.h>
#include <nw/eft/eft2_System.h>
#include <nw/eft/eftvw2_ViewerSystem.h>
#include <nw/eft/eftvw2_FileSystem.h>
#if EFT_IS_WIN
#include <fstream>
#endif
#include <DemoEmitterSet.h>
#include <nw/eft/eftut2_Heap.h>
#include <cafe/gx2/gx2Enum.h>


nw::ut::MemoryAllocator*        g_NwAllocator = NULL;
nw::eftut2::NwHeap              g_DemoHeap;             // デモヒープ


// エフェクト関連
nw::eft2::System*           g_EffectSystem          = NULL;
nw::eftvw2::ViewerSystem*   g_EffectViewerSystem    = NULL;
u32                         g_EffectDemoResID       = 1;        // デモグリソースID
u8                          g_EffectDemoGroupID     = 1;        // デモグループID
void*                       g_EffectDemoBinary      = NULL;     // エフェクトデモバイナリ
u32                         g_EffectDemoBinarySize  = 0;        // エフェクトデモバイナリサイズ

void*                       g_G3dCarBinary          = NULL;     // 車バイナリ
u32                         g_G3dCarBinarySize      = 0;        // 車バイナリサイズ
void*                       g_G3dGroundBinary       = NULL;     // 地面バイナリ
u32                         g_G3dGroundBinarySize   = 0;        // 地面バイナリサイズ
void*                       g_G3dSkyBinary          = NULL;     // そらバイナリ
u32                         g_G3dSkyBinarySize      = 0;        // そらバイナリサイズ
void*                       g_G3dMountainBinary     = NULL;     // 山バイナリ
u32                         g_G3dMountainBinarySize = 0;        // 山バイナリサイズ

nw::eft2::Handle            g_CarEffectHandle;
nw::eft2::Handle            g_MountainEffectHandle;
nw::eft2::Handle            g_Fireworks1EffectHandle;
nw::eft2::Handle            g_Fireworks2EffectHandle;
nw::eft2::Handle            g_Fireworks3EffectHandle;
nw::eft2::Handle            g_Fireworks4EffectHandle;

nw::eft2::Handle            g_ManualEmitterHandle;
nw::eft2::Handle            g_ManualEmitter1LifePtclHandle;


G3dModelPreview*            g_CarPreview            = NULL;
G3dModelPreview*            g_GroundPreview         = NULL;
G3dModelPreview*            g_SkyPreview            = NULL;
G3dModelPreview*            g_MoutainPreview        = NULL;
bool                        g_IsDemoInitialized     = false;

//------------------------------------------------------------------------------
//  バイナリロード
//------------------------------------------------------------------------------
struct _loadArg
{
    void* binary;
    u32   binarySize;
};

bool _binaryLoad( _loadArg& arg, const char* path )
{
    nw::dev::FileDeviceManager* fileSystem = nw::dev::FileDeviceManager::GetInstance();
    if ( !fileSystem )
    {
        return false;
    }

    nw::dev::FileDevice::LoadArg loadArg;
    loadArg.path            = path;
    loadArg.allocator       = g_NwAllocator;
    loadArg.alignment       = nw::eft2::EFT_PTCL_BINARY_ALIGNMENT;
    arg.binary              = fileSystem->Load( loadArg );
    arg.binarySize          = loadArg.readSize;

    if ( !arg.binary )
    {
        return false;
    }
    return true;
}

void _binaryUnLoad( void* binary )
{
    if ( binary )
    {
        g_NwAllocator->Free( binary );
    }
}


//------------------------------------------------------------------------------
//  デモ初期化処理
//------------------------------------------------------------------------------
void Demo_Initialize( nw::ut::MemoryAllocator* allocator, nw::eft2::System* effectSystem, nw::eftvw2::ViewerSystem* effectViewerSystem )
{
    g_NwAllocator   = allocator;
    g_DemoHeap.SetNwAllocator( allocator );
    g_EffectSystem          = effectSystem;
    g_EffectViewerSystem    = effectViewerSystem;

    // デモ用のエフェクトバイナリ準備
    _loadArg arg;
    if ( _binaryLoad( arg, "effectDemoBinary.ptcl" ) )
    {
        g_EffectDemoBinary      = arg.binary;
        g_EffectDemoBinarySize  = arg.binarySize;
        effectSystem->EntryResource( &g_DemoHeap, g_EffectDemoBinary, g_EffectDemoResID );

        effectSystem->GetResource( g_EffectDemoResID )->OutputResourceInfo();
    }

    if ( _binaryLoad( arg, "effectDemoCar.bfres" ) )
    {
        g_G3dCarBinary      = arg.binary;
        g_G3dCarBinarySize  = arg.binarySize;
    }
    if ( _binaryLoad( arg, "effectDemoGround.bfres" ) )
    {
        g_G3dGroundBinary      = arg.binary;
        g_G3dGroundBinarySize  = arg.binarySize;
    }
    if ( _binaryLoad( arg, "effectDemoSky.bfres" ) )
    {
        g_G3dSkyBinary      = arg.binary;
        g_G3dSkyBinarySize  = arg.binarySize;
    }
    if ( _binaryLoad( arg, "effectDemoMountain.bfres" ) )
    {
        g_G3dMountainBinary      = arg.binary;
        g_G3dMountainBinarySize  = arg.binarySize;
    }

    // オブジェクト生成
    if ( g_EffectDemoBinary && g_G3dCarBinary && g_G3dGroundBinary && g_G3dSkyBinary )
    {
        // エフェクト生成
        g_EffectSystem->CreateEmitterSetID( &g_CarEffectHandle,      Demo::CarSmoke,     g_EffectDemoResID, g_EffectDemoGroupID );
        g_EffectSystem->CreateEmitterSetID( &g_MountainEffectHandle, Demo::SmokeVolcano, g_EffectDemoResID, g_EffectDemoGroupID );

        g_EffectSystem->CreateEmitterSetID( &g_Fireworks1EffectHandle, Demo::Fireworks1, g_EffectDemoResID, g_EffectDemoGroupID );
        if ( g_Fireworks1EffectHandle.IsValid() )
        {
            g_Fireworks1EffectHandle.GetEmitterSet()->SetPos( nw::math::VEC3( 200.f, 0.0f, 0.0f ), 4 );
        }
        g_EffectSystem->CreateEmitterSetID( &g_Fireworks2EffectHandle, Demo::Fireworks2, g_EffectDemoResID, g_EffectDemoGroupID );
        if ( g_Fireworks2EffectHandle.IsValid() )
        {
            g_Fireworks2EffectHandle.GetEmitterSet()->SetPos( nw::math::VEC3( 200.f, 0.0f, 0.0f ), 4 );
        }
        g_EffectSystem->CreateEmitterSetID( &g_Fireworks3EffectHandle, Demo::Fireworks3, g_EffectDemoResID, g_EffectDemoGroupID );
        if ( g_Fireworks3EffectHandle.IsValid() )
        {
            g_Fireworks3EffectHandle.GetEmitterSet()->SetPos( nw::math::VEC3( 200.f, 0.0f, 0.0f ), 4 );
        }
        g_EffectSystem->CreateEmitterSetID( &g_Fireworks4EffectHandle, Demo::Fireworks4, g_EffectDemoResID, g_EffectDemoGroupID );
        if ( g_Fireworks4EffectHandle.IsValid() )
        {
            g_Fireworks4EffectHandle.GetEmitterSet()->SetPos( nw::math::VEC3( 200.f, 0.0f, 0.0f ), 4 );
        }

        // マニュアルエミッタテスト用ハンドル
        g_EffectSystem->CreateManualEmitEmitterSetID( &g_ManualEmitterHandle,
                                                      Demo::ManualEmitter,
                                                      g_EffectDemoResID,
                                                      g_EffectDemoGroupID,
                                                      100 );
        if ( g_ManualEmitterHandle.IsValid() )
        {
            g_ManualEmitterHandle.GetEmitterSet()->SetPos( nw::math::VEC3( 0.f, 0.0f, -100.0f ), 4 );

            for( u32 i = 0; i < 50; i++ )
            {
                g_ManualEmitterHandle.GetEmitterSet()->EmitParticle( nw::math::VEC3( 0.f, 0.0f, 0.0f ) );
            }
        }

        g_EffectSystem->CreateEmitterSetID( &g_ManualEmitter1LifePtclHandle,
                                                      Demo::OneLifePtcl,
                                                      g_EffectDemoResID,
                                                      g_EffectDemoGroupID );
        g_ManualEmitter1LifePtclHandle.GetEmitterSet()->SetManualParticleEmissionWithParticleCount( 100 );



        nw::eftvw2::ResModelPreview dummyResModelPreview;
        dummyResModelPreview.animSpeed      = 1.0f;
        dummyResModelPreview.animStartFrame = 0.0f;

        nw::eftcom::Guid guid;
        g_CarPreview = static_cast<G3dModelPreview*>(
            G3dModelPreview::CreateModelPreview( &g_DemoHeap, NULL, g_G3dCarBinary, g_G3dCarBinarySize, guid ) );
        if ( g_CarPreview )
        {
            g_CarPreview->SetResModelPreview( &dummyResModelPreview );
            g_EffectViewerSystem->AddPreview( g_CarPreview );
        }

        g_GroundPreview = static_cast<G3dModelPreview*>(
            G3dModelPreview::CreateModelPreview( &g_DemoHeap, NULL, g_G3dGroundBinary, g_G3dGroundBinarySize, guid ) );
        if ( g_GroundPreview )
        {
            g_GroundPreview->SetResModelPreview( &dummyResModelPreview );
            g_EffectViewerSystem->AddPreview( g_GroundPreview );

            nw::math::Matrix34 matrix;
            matrix.SetIdentity();
            matrix.SetScale( nw::math::VEC3( 150.f, 150.f, 150.f ) );
            g_GroundPreview->SetResMatrix( matrix );
        }

        g_SkyPreview = static_cast<G3dModelPreview*>(
            G3dModelPreview::CreateModelPreview( &g_DemoHeap, NULL, g_G3dSkyBinary, g_G3dSkyBinarySize, guid ) );
        if ( g_SkyPreview )
        {
            g_SkyPreview->SetResModelPreview( &dummyResModelPreview );
            g_EffectViewerSystem->AddPreview( g_SkyPreview );

            nw::math::Matrix34 rotMatrix;
            rotMatrix.SetIdentity();
            rotMatrix.SetRotate( nw::math::VEC3( 1.f, 0.f, 0.f ), NW_MATH_DEG_TO_RAD( 180 ) );
            nw::math::Matrix34 sclMatrix;
            sclMatrix.SetScale( nw::math::VEC3( 150, -150.f, 150.f ) );

            nw::math::Matrix34 matrix;
            matrix.SetIdentity();
            matrix.SetMult( rotMatrix, sclMatrix );
            g_SkyPreview->SetResMatrix( matrix );
        }
#if 1
        g_MoutainPreview = static_cast<G3dModelPreview*>(
            G3dModelPreview::CreateModelPreview( &g_DemoHeap, NULL, g_G3dMountainBinary, g_G3dMountainBinarySize, guid ) );
        if ( g_MoutainPreview )
        {
            g_MoutainPreview->SetResModelPreview( &dummyResModelPreview );
            g_EffectViewerSystem->AddPreview( g_MoutainPreview );

            nw::math::Matrix34 trsMatrix;
            trsMatrix.SetIdentity();
            trsMatrix.SetTranslate( nw::math::VEC3( 500.f, 150.f, 0.f ) );
            nw::math::Matrix34 sclMatrix;
            sclMatrix.SetScale( nw::math::VEC3( 10.f, 10.f, 10.f ) );

            nw::math::Matrix34 matrix;
            matrix.SetIdentity();
            matrix.SetMult( trsMatrix, sclMatrix );
            g_MoutainPreview->SetResMatrix( matrix );
        }
#endif

        g_IsDemoInitialized = true;
    }
} // NOLINT(readability/fn_size)

//------------------------------------------------------------------------------
//  デモ終了処理
//------------------------------------------------------------------------------
void Demo_Finalize()
{
    g_EffectSystem->ClearResource( &g_DemoHeap, g_EffectDemoResID );

    _binaryUnLoad( g_EffectDemoBinary );
    _binaryUnLoad( g_G3dCarBinary );
    _binaryUnLoad( g_G3dGroundBinary );
    _binaryUnLoad( g_G3dSkyBinary );
}

//------------------------------------------------------------------------------
//  デモ計算処理
//------------------------------------------------------------------------------
void Demo_ProcCalc()
{
    static u32 g_Counter = 0;

    if ( !g_IsDemoInitialized )
    {
        return;
    }

    // 車にエフェクトを親子付け
    if ( g_CarEffectHandle.IsValid() )
    {
        nw::math::MTX34 boneMatrix;
        boneMatrix.SetIdentity();
        g_CarPreview->GetMatrix( &boneMatrix, 5 );
        g_CarEffectHandle.GetEmitterSet()->SetMatrix( boneMatrix );
    }

    // 山に山エフェクトを親子付け
    if ( g_MountainEffectHandle.IsValid() )
    {
        nw::math::MTX34 boneMatrix;
        boneMatrix.SetIdentity();
        g_MoutainPreview->GetMatrix( &boneMatrix, 0 );
        g_MountainEffectHandle.GetEmitterSet()->SetMatrix( boneMatrix );
    }

    if ( g_ManualEmitter1LifePtclHandle.IsValid() )
    {
        nw::math::VEC3 pos[10];
        for ( u32 i = 0; i < 10; i++ )
        {
            pos[i].Set( i * 20.f, 0.0f, -100.0f );
        }
        //g_ManualEmitter1LifePtclHandle.GetEmitterSet()->SetParticleScale( 3.f );
        g_ManualEmitter1LifePtclHandle.GetEmitterSet()->SetParticleEmissionPoints( 10, pos );
    }

    g_EffectSystem->Calc( g_EffectDemoGroupID, 1.0f, true );

    g_Counter++;
}

//------------------------------------------------------------------------------
//  デモ描画処理
//------------------------------------------------------------------------------
void Demo_ProcDraw()
{
    if ( !g_IsDemoInitialized )
    {
        return;
    }

    g_EffectSystem->Draw( g_EffectDemoGroupID, 0xFFFFFFFF, true );
}
