﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dev.h>
#include <nw/eft/eft2_System.h>
#include "effectdemo.h"
#include "CustomShaderSample.h"

nw::eftdemo::LightMapTexture CustomShaderSample::m_LightMap;      // 簡易ライトマップテクスチャ実体
nw::math::Matrix44           CustomShaderSample::m_LightViewProj; // ライトビュープロジェクションマトリクス実体


//------------------------------------------------------------------------------
//  初期化
//------------------------------------------------------------------------------
void CustomShaderSample::Initialize( nw::eft2::System* system, nw::ut::IAllocator* allocator )
{
    nw::eft2::CallbackSet set;
    set.renderStateSet      = _RenderStateSetCallback;
    system->SetCallback( nw::eft2::EFT_CUSTOM_SHADER_CALLBACK_ID_1, set );

    // 茶色→水色のライトマップを生成
    m_LightMap.CreateImage(  allocator, 64, 64,
        nw::math::VEC3( 0.3f, 0.2f, 0.0f ), 0.2f,
        nw::math::VEC3( 0.4f, 0.6f, 0.5f ), 0.6f,
        nw::math::VEC3( 0.5f, 1.0f, 1.0f ), 0.8f );

    m_LightViewProj.SetIdentity();
}

//------------------------------------------------------------------------------
//  ライトビューマトリクス設定
//------------------------------------------------------------------------------
void CustomShaderSample::SetLightViewProjectionMatrix( nw::math::Matrix44& matrix )
{
    m_LightViewProj = matrix;
}

//------------------------------------------------------------------------------
//  描画設定後コールバック
//------------------------------------------------------------------------------
bool CustomShaderSample::_RenderStateSetCallback( nw::eft2::RenderStateSetArg& arg )
{
    if ( !arg.emitter->emitterRes->customShaderParam )
    {
        return false;
    }

    nw::eft2::System* system = arg.GetSystem();
    nw::eft2::Shader* shader = arg.GetShader();

    struct CustomShaderSampleUniformBlock0
    {
        nw::math::VEC4      fogParam;
        nw::math::VEC4      fogColor;
        nw::math::VEC4      lightVec;
        nw::math::Matrix44  lightViewProj;
    };

    // ユニフォームブロック用のバッファを確保
    CustomShaderSampleUniformBlock0* ubo0 = static_cast<CustomShaderSampleUniformBlock0 *>( system->AllocFromTempBuffer( sizeof(CustomShaderSampleUniformBlock0) ) );

    // ユニフォームブロックパラメータを設定
    if ( ubo0 )
    {
        ubo0->fogParam.x   = 100.f;     // Fog Near
        ubo0->fogParam.y   = 200.f;     // Fog Far
        ubo0->fogParam.z   = 0.f;       // Empty
        ubo0->fogParam.w   = 0.f;       // Empty
        ubo0->fogColor.x   = 0.2f;      // Fog Color R
        ubo0->fogColor.y   = 0.2f;      // Fog Color G
        ubo0->fogColor.z   = 0.2f;      // Fog Color B
        ubo0->fogColor.w   = 1.0f;      // Fog Color A
        ubo0->lightVec.x   = 0.0f;      // Light PosX
        ubo0->lightVec.y   = 200.0f;    // Light PosY
        ubo0->lightVec.z   = 200.0f;    // Light PosZ
        ubo0->lightVec.z   = 0.0f;      // Empty
        memcpy( ubo0->lightViewProj, &m_LightViewProj, sizeof(nw::math::Matrix44) ); // Lightview

        // 独自構造体パラメータをUBOをして利用
        shader->BindCustomShaderUniformBlock( nw::eft2::EFT_CUSTOM_SHADER_UBO_0, ubo0, sizeof( CustomShaderSampleUniformBlock0 ) );
    }

    // EffectMakerで設定されたfloat配列をUBOとして利用
    shader->BindReservedCustomShaderUniformBlock( arg.emitter );

    // ライトマップ設定
#if EFT_OPENGL
    system->BindCustomShaderTexture( nw::eft2::EFT_CUSTOM_SHADER_TEXTURE_2D_1, m_LightMap.GetGLTextureID() );
#endif
#if EFT_GX2
    system->BindCustomShaderTexture( nw::eft2::EFT_CUSTOM_SHADER_TEXTURE_2D_1, m_LightMap.GetGX2Texture() );
#endif

    // キューブマップテクスチャを設定
    //system->BindCustomShaderTexture( nw::eft2::EFT_CUSTOM_SHADER_TEXTURE_CUBE_MAP_0, g_CubeMapTexture );

    return true;
}



