﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nw/dev.h>
#include <nw/eft/eft2_System.h>


//---------------------------------------------------
//  背景テクスチャ管理 クラス です。
//---------------------------------------------------
class BackGroundTexture
{
public:
    //------------------------------------------------------------------------------
    //! @brief  コンストラクタ
    //------------------------------------------------------------------------------
    explicit BackGroundTexture( nw::eft2::Heap* heap )
    {
        m_Heap          = heap;
        m_TexBuffer     = NULL;
        m_TexBufferSize = 0;
    }

    //------------------------------------------------------------------------------
    //! @brief  デストラクタ
    //------------------------------------------------------------------------------
    ~BackGroundTexture()
    {
        Unload();
    }

    //------------------------------------------------------------------------------
    //! @brief  背景テクスチャをセットアップする
    //------------------------------------------------------------------------------
    bool Setup( u32 id, nw::eft2::ResTexture* resTexture, void* texBuffer, u32 texBufferSize )
    {
        Unload();

        if ( ( resTexture->width > 0 ) && ( resTexture->height > 0 ) )
        {
            m_TexBuffer = m_Heap->Alloc( texBufferSize, 4096 );
            memcpy( m_TexBuffer, texBuffer, texBufferSize );
            m_TexBufferSize = texBufferSize;

            m_TextureResource.InitializeGx2bImage( id, resTexture, m_TexBuffer, m_TexBufferSize );
        }

        return false;
    }

    //------------------------------------------------------------------------------
    //! @brief  背景テクスチャを破棄する
    //------------------------------------------------------------------------------
    bool Unload()
    {
        if ( m_TexBuffer )
        {
            m_TextureResource.Finalize();
            m_Heap->Free( m_TexBuffer );
            m_TexBuffer     = NULL;
            m_TexBufferSize = 0;
            return true;
        }

        return false;
    }

    //------------------------------------------------------------------------------
    //! @brief  テクスチャリソースを取得する
    //------------------------------------------------------------------------------
    const nw::eft2::TextureResource* GetTextureResource()
    {
        if ( !m_TexBuffer )
        {
            return NULL;
        }
        return &m_TextureResource;
    }

private:
    nw::eft2::Heap*             m_Heap;
    nw::eft2::TextureResource   m_TextureResource;
    void*                       m_TexBuffer;
    u32                         m_TexBufferSize;
};
