﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/types.h>
#include <nw/eft2.h>

namespace nw      {
namespace eftdemo {


//---------------------------------------------------------------------------
//! @brief        描画パラメータ
//---------------------------------------------------------------------------
class DrawParam
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    DrawParam()
    {
        mCameraPos.Set( 0.f, 100.f, 100.f );
        mLightTarget.Set( 0.0f, 0.0f, 0.0f );
        mViewMtx.SetLookAt( mCameraPos, nw::math::VEC3( 0.0f, 1.0f, 0.0f ), mLightTarget );
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビューを取得します。
    //---------------------------------------------------------------------------
    const nw::math::Matrix34& GetLightView() const
    {
        return mViewMtx;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビューを位置を取得します。
    //---------------------------------------------------------------------------
    const nw::math::VEC3& GetLightPosition() const
    {
        return mCameraPos;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビューを視点を取得します。
    //---------------------------------------------------------------------------
    const nw::math::VEC3& GetLightTarget() const
    {
        return mLightTarget;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビュー位置を取得します。
    //---------------------------------------------------------------------------
    void SetLightPosition( nw::math::VEC3 pos )
    {
        mCameraPos = pos;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビュー視点を取得します。
    //---------------------------------------------------------------------------
    void SetLightTarget( nw::math::VEC3 target )
    {
        mLightTarget = target;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビューマトリクスを更新します。
    //---------------------------------------------------------------------------
    void Update()
    {
        mViewMtx.SetLookAt( mCameraPos, nw::math::VEC3( 0.0f, 1.0f, 0.0f ), mLightTarget );
    }


    nw::math::Matrix44              mProjMtx;           //!< プロジェクションマトリクス
    nw::math::Matrix34              mViewMtx;           //!< ビューマトリクス
    nw::math::Vector3               mCameraPos;         //!< カメラ位置
    nw::math::Vector3               mLightTarget;       //!< ライト視点
    f32                             mNearZ;             //!< スクリーンNear値
    f32                             mFarZ;              //!< スクリーンFar値
    f32                             mFrameRate;         //!< フレームレート
    nw::dev::PrimitiveRenderer*     mPrimitiveRenderer; //!< プリミティブレンダラ

    nw::eft2::TextureInterface      mCubeMap;           //!< キューブマップテクスチャ
    nw::eft2::TextureInterface      mShadowMap;         //!< シャドウマップテクスチャ

//    nw::eft::RenderEmitterProfilerCallback mGpuProfiler;//!< Gpuプロファイラコールバック
};


//---------------------------------------------------------------------------
//! @brief      ライトパラメータ
//---------------------------------------------------------------------------
class LightParam : public DrawParam
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    LightParam()
    {
        mCameraPos.Set( 0.f, 100.f, 100.f );
        mLightTarget.Set( 0.0f, 0.0f, 0.0f );
        mViewMtx.SetLookAt( mCameraPos, nw::math::VEC3( 0.0f, 1.0f, 0.0f ), mLightTarget );
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビューを取得します。
    //---------------------------------------------------------------------------
    const nw::math::Matrix34& GetLightView() const
    {
        return mViewMtx;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビューを位置を取得します。
    //---------------------------------------------------------------------------
    const nw::math::VEC3& GetLightPosition() const
    {
        return mCameraPos;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビューを視点を取得します。
    //---------------------------------------------------------------------------
    const nw::math::VEC3& GetLightTarget() const
    {
        return mLightTarget;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビュー位置を取得します。
    //---------------------------------------------------------------------------
    void SetLightPosition( nw::math::VEC3 pos )
    {
        mCameraPos = pos;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビュー視点を取得します。
    //---------------------------------------------------------------------------
    void SetLightTarget( nw::math::VEC3 target )
    {
        mLightTarget = target;
    }

    //---------------------------------------------------------------------------
    //! @brief        ライトビューマトリクスを更新します。
    //---------------------------------------------------------------------------
    void Update()
    {
        mViewMtx.SetLookAt( mCameraPos, nw::math::VEC3( 0.0f, 1.0f, 0.0f ), mLightTarget );
    }

    nw::math::VEC3                  mLightTarget;       //!< ライト視点
};


} // namespace eftdemo
} // namespace nw
