﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <eftdemo_System.h>
#include <eftdemo_FrameBuffer.h>
#include <eftdemo_ScreenDrawer.h>

namespace nw      {
namespace eftdemo {

enum
{
    GLARE_BUFFER_MAX = 5
};

//---------------------------------------------------------------------------
//! @brief      グレアエフェクトクラス
//---------------------------------------------------------------------------
class GlareEffect
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    GlareEffect();

    //---------------------------------------------------------------------------
    //! @brief        初期化処理です。
    //---------------------------------------------------------------------------
    void Initialize( nw::ut::MemoryAllocator* allocator, f32 width, f32 height );

    //---------------------------------------------------------------------------
    //! @brief        描画処理です。
    //---------------------------------------------------------------------------
    void Draw( nw::eftdemo::ScreenDrawer* drawer, nw::eftdemo::FrameBuffer* currentFrameBuffer, u32 glareNum );

private:
    FrameBuffer        mFrameBufferTextureGlareX[GLARE_BUFFER_MAX];   //!< フレームバッファ
    FrameBuffer        mFrameBufferTextureGlareY[GLARE_BUFFER_MAX];   //!< フレームバッファ

    //! ガウスフィルタの重み
    f32                mWeightValue[GLARE_BUFFER_MAX][ScreenDrawer::GAUSS_LENGTH];
};


} // namespace eftdemo
} // namespace nw
