﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cmath>

#include <nw/dev.h>

#include "eftdemo_bitmap.h"

int Write_Bmp(const char *filename, Image *img)
{
    int i, j;
    FILE *fp;
    int real_width;
    unsigned char *bmp_line_data; //画像1行分のRGB情報を格納する
    unsigned char header_buf[HEADERSIZE]; //ヘッダを格納する
    unsigned int file_size;
    unsigned int offset_to_data;
    unsigned long info_header_size;
    unsigned int planes;
    unsigned int color;
    unsigned long compress;
    unsigned long data_size;
    long xppm;
    long yppm;

    if((fp = fopen(filename, "wb")) == NULL)
    {
        fprintf(stderr, "Error: %s could not open.", filename);
        return 1;
    }

    real_width = img->width * 3 + img->width % 4;

    //ここからヘッダ作成
    file_size = img->height * real_width + HEADERSIZE;
    offset_to_data = HEADERSIZE;
    info_header_size = INFOHEADERSIZE;
    planes = 1;
    color = 24;
    compress = 0;
    data_size = img->height * real_width;
    xppm = 1;
    yppm = 1;

    header_buf[0] = 'B';
    header_buf[1] = 'M';
    memcpy(header_buf + 2, &file_size, sizeof(file_size));
    header_buf[6] = 0;
    header_buf[7] = 0;
    header_buf[8] = 0;
    header_buf[9] = 0;
    memcpy(header_buf + 10, &offset_to_data, sizeof(file_size));
    header_buf[11] = 0;
    header_buf[12] = 0;
    header_buf[13] = 0;

    memcpy(header_buf + 14, &info_header_size, sizeof(info_header_size));
    header_buf[15] = 0;
    header_buf[16] = 0;
    header_buf[17] = 0;
    memcpy(header_buf + 18, &img->width, sizeof(img->width));
    memcpy(header_buf + 22, &img->height, sizeof(img->height));
    memcpy(header_buf + 26, &planes, sizeof(planes));
    memcpy(header_buf + 28, &color, sizeof(color));
    memcpy(header_buf + 30, &compress, sizeof(compress));
    memcpy(header_buf + 34, &data_size, sizeof(data_size));
    memcpy(header_buf + 38, &xppm, sizeof(xppm));
    memcpy(header_buf + 42, &yppm, sizeof(yppm));
    header_buf[46] = 0;
    header_buf[47] = 0;
    header_buf[48] = 0;
    header_buf[49] = 0;
    header_buf[50] = 0;
    header_buf[51] = 0;
    header_buf[52] = 0;
    header_buf[53] = 0;

    //ヘッダの書き込み
    fwrite(header_buf, sizeof(unsigned char), HEADERSIZE, fp);

    if((bmp_line_data = (unsigned char *)malloc(sizeof(unsigned char) * real_width)) == NULL)
    {
        fprintf(stderr, "Error: Allocation error.\n");
        fclose(fp);
        return 1;
    }

    //RGB情報の書き込み
    for(i=0; i<(int)img->height; i++)
    {
        for(j=0; j<(int)img->width; j++)
        {
            bmp_line_data[j * 3]        =   img->data[i * img->width + j].r;
            bmp_line_data[j * 3 + 1]    =   img->data[i * img->width + j].g;
            bmp_line_data[j * 3 + 2]    =   img->data[i * img->width + j].b;
        }
        //RGB情報を4バイトの倍数に合わせている
        for(j=img->width * 3; j<real_width; j++)
        {
            bmp_line_data[j] = 0;
        }
        fwrite(bmp_line_data, sizeof(unsigned char), real_width, fp);
    }

    free(bmp_line_data);

    fclose(fp);

    return 0;
}

Image *Create_Image(int width, int height)
{
    Image *img;

    if((img = (Image *)malloc(sizeof(Image))) == NULL)
    {
        fprintf(stderr, "Allocation error\n");
        return NULL;
    }

    if((img->data = (Rgb*)malloc(sizeof(Rgb) * width*height)) == NULL)
    {
        fprintf(stderr, "Allocation error\n");
        free(img);
        return NULL;
    }

    img->width = width;
    img->height = height;

    return img;
}

//動的に取得したRGB情報の開放
void Free_Image(Image *img)
{
    free(img->data);
    free(img);
}


//----------------------------------------
// カレントバッファをBMPとして保存
//----------------------------------------
void SaveCurrentBufferAsBmpFile( f32 width, f32 height, const char* filename )
{
    // 画面キャプチャ
    GLubyte* pixel_data = (GLubyte*)malloc(((size_t)width) * ((size_t)height) * 3 * (sizeof(GLubyte)));
    // データ格納のサイズを設定
    glPixelStorei(GL_PACK_ALIGNMENT ,1);
    // データの読み出し
    glReadPixels(
        0,0,
        (GLsizei)width,(GLsizei)height,
        GL_RGB,
        GL_UNSIGNED_BYTE,
        pixel_data);

    Image image;
    image.height = (u32)height;
    image.width = (u32)width;
    image.data = (Rgb *)pixel_data;
    Write_Bmp( filename, &image );

    free(pixel_data);
}
