﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConverterTestApp
{
    /// <summary>
    /// コンバートテストクラス
    /// </summary>
    internal class ConvertTest
    {
        /// <summary>
        /// コンバート実行
        /// </summary>
        /// <param name="exePath">EffectMaker.exeのファイルパス</param>
        /// <param name="rootPath">コンバートリストファイルが存在するディレクトリ</param>
        /// <param name="convertXmlFile">コンバートリストファイルの名前</param>
        /// <param name="outFile">出力バイナリファイル名</param>
        /// <param name="platform">プラットフォーム</param>
        /// <param name="inCommand">EffectMakerに渡すコマンド</param>
        public bool Convert(string exePath, string rootPath, string convertXmlFile, string outFile, string platform, string inCommand = "")
        {
            var cmd = inCommand;
            if (cmd == string.Empty)
            {
                var convListPath = rootPath + "/" + convertXmlFile;

                // コンバートリストがない場合はその場で終了
                if (!Utility.CheckFile(convListPath))
                {
                    return false;
                }
                cmd += "--convert-list " + convListPath;

                // 出力ファイルの設定
                cmd += " -o " + outFile;

                // プロジェクト設定ファイル
                string prjConfig = rootPath + "/prjconfig.xml";
                if (File.Exists(prjConfig))
                {
                    cmd += " --team-setting-file " + prjConfig;
                }

                // プラットフォームの設定
                cmd += " --platform " + platform;
            }

            // コンバート開始
            return Utility.ExecuteCommand(exePath, cmd);
        }
    }
}
