﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using DevMenuCommandTest;

namespace DevMenuCommandTestNuiShell
{
    [TestClass]
    public class TestApplicationLanguage : TestBase
    {
        public override void DoCleanup()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            command.Execute(new string[] {
                "application uninstall --all",
            });
        }

        [TestMethod]
        [Timeout(600 * 1000)]
        public void ApplicationLanguage()
        {
            // (検証対象の言語, 優先度の低い言語)
            List<Tuple<string, string>> languageList = new List<Tuple<string, string>>();
            languageList.Add(Tuple.Create("AmericanEnglish", "Japanese"));
            languageList.Add(Tuple.Create("BritishEnglish", "Japanese"));
            languageList.Add(Tuple.Create("Japanese", "AmericanEnglish"));
            languageList.Add(Tuple.Create("French", "Japanese"));
            languageList.Add(Tuple.Create("German", "Japanese"));
            languageList.Add(Tuple.Create("LatinAmericanSpanish", "Japanese"));
            languageList.Add(Tuple.Create("Spanish", "Japanese"));
            languageList.Add(Tuple.Create("Italian", "Japanese"));
            languageList.Add(Tuple.Create("Dutch", "Japanese"));
            languageList.Add(Tuple.Create("CanadianFrench", "Japanese"));
            languageList.Add(Tuple.Create("Portuguese", "Japanese"));
            languageList.Add(Tuple.Create("Russian", "Japanese"));
            languageList.Add(Tuple.Create("SimplifiedChinese", "Japanese"));
            languageList.Add(Tuple.Create("TraditionalChinese", "Japanese"));
            languageList.Add(Tuple.Create("Korean", "TraditionalChinese"));

            var command = new DevMenuCommandSystem(this.TestContext);

            Func<string, string[]> MakeLanguageProperty = (string language) =>
            {
                return new string[]
                {
                    "<Title>",
                    "   <Name>Title</Name>",
                    "   <Publisher>Publisher</Publisher>",
                    string.Format("   <Language>{0}</Language>", language),
                    "</Title>",
                    "<Icon>",
                    string.Format("   <Language>{0}</Language>", language),
                    string.Format("   <IconPath>{0}/../../../Programs/Iris/Resources/SpecFiles/NintendoSDK_Application.bmp</IconPath>", m_Maker.GetOutputDirectory().Replace("\"", "").Replace("\\", "/")),
                    "</Icon>",
                    string.Format("<SupportedLanguage>{0}</SupportedLanguage>", language),
                };
            };

            var outputDir = m_Maker.GetOutputDirectory().Replace("\"", "");
            var metaFilePath = Path.Combine(outputDir, "language.nmeta");

            foreach (var item in languageList)
            {
                var targetLanguage = item.Item1;
                var lowestLanguage = item.Item2;
                var targetLanguageProperty = MakeLanguageProperty(targetLanguage);
                var lowestLanguageProperty = MakeLanguageProperty(lowestLanguage);
                var mergedTitleProperty = new List<string>(targetLanguageProperty);
                mergedTitleProperty.AddRange(lowestLanguageProperty);

                ulong id = 0x0100394000059000;

                // タイトルを１つ設定できる
                MakeTestApplicationMetaFile(metaFilePath, id, targetLanguageProperty);
                Assert.IsTrue(File.Exists(metaFilePath));
                var appv0 = m_Maker.MakeApplication(id, metaFilePath: metaFilePath);
                command.Execute(new string[]
                    {
                        "application install " + appv0.Path,
                        string.Format("application get-desired-language 0x{0:X16}", id)
                    }, targetLanguage);

                command.Execute(new string[]
                    {
                        string.Format("application uninstall 0x{0:X16}", id)
                    });

                // 複数設定されているときに優先度に沿って設定出来ている
                MakeTestApplicationMetaFile(metaFilePath, id, mergedTitleProperty);
                appv0 = m_Maker.MakeApplication(id, metaFilePath:metaFilePath);
                command.Execute(new string[]
                    {
                        "application install " + appv0.Path,
                        "debug set-device-language " + targetLanguage,
                        string.Format("application get-desired-language 0x{0:X16}", id)
                    }, targetLanguage);

                command.Execute(new string[]
                    {
                        string.Format("application uninstall 0x{0:X16}", id)
                    });
            }
        }

    }
}

