﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DevMenuCommandTest
{
    public enum LcsState : UInt32
    {
        None,
        Initialized,
        Opened,
        Joined,
        Transferring,
        ContentsShareFailed,
        Suspened,
        Completed
    };

    public enum LcsFailureReason : UInt32
    {
        None,
        FlightMode,
        Sleep,
        CommunicationError,
        NodeLeaved,
        CannotUpdateSystem,
        ContentsCorrupted,
        NotExistDownloadContents,
        BuiltInStorageError,
        GameCardError,
        SdCardError,
        StorageError,
        UnknownError,
        UnshareableContents,
        NotEnoughStorageSpace
    };

    public enum LcsSuspendedReason : UInt32
    {
        None,
        IncompatibleContentsInfo,
        NeedTerminateApplication,
        EulaRequired,
        RebootRequired,
        StorageSpaceNotEnough,
        StorageSpaceNotEnoughOnRequiredNode,
    };
}
