﻿using System;
using System.IO;
using System.Text.RegularExpressions;
using System.Collections.Generic;
using System.Web.Script.Serialization;

namespace DevMenuCommandTest
{
    public class ContentInfoForJson
    {
        public string id { get; set; }
        public string type { get; set; }
        public int size { get; set; }
    }

    public class ContentMetaDatabaseForJson
    {
        public string id { get; set; }
        public int version { get; set; }
        public string type { get; set; }
        public List<ContentInfoForJson> contentInfoList { get; set; }

        public static List<ContentMetaDatabaseForJson> Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<List<ContentMetaDatabaseForJson>>(output);
        }
    }

    public class ApplicationViewForJson
    {
        public string id { get; set; }
        public uint version { get; set; }
        public bool hasRecord { get; set; }
        public bool hasMainRecord { get; set; }
        public bool hasPatchRecord { get; set; }
        public bool hasAddOnContentRecord { get; set; }
        public bool hasMainInstallRecord { get; set; }
        public bool isDownloading { get; set; }
        public bool isGameCard { get; set; }
        public bool hasGameCardEntity { get; set; }
        public bool isLaunchable { get; set; }
        public bool hasAllEntity { get; set; }
        public bool hasMainEntity { get; set; }
        public bool hasAllAddOnContentEntity { get; set; }
        public bool hasPatchEntity { get; set; }
        public bool maybeCorrupted { get; set; }
        public bool isWaitingApplicationCommit { get; set; }
        public bool isWaitingCommit { get; set; }
        public bool isWaitingAocCommit { get; set; }
        public bool isWaitingPatchInstall { get; set; }
        public bool isAutoDeleteDisabled { get; set; }
        public bool isApplyingDelta { get; set; }
        public bool hasAnyAddOnContentEntity { get; set; }
        public bool isCleanupAddOnContentWithNoRightsRecommended  { get; set; }
        public DownloadProgressForJson progress { get; set; }

        public static List<ApplicationViewForJson> Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<List<ApplicationViewForJson>>(output);
        }
    }

    public class DownloadProgressForJson
    {
        public Int64 downloaded { get; set; }
        public Int64 total { get; set; }
        public string lastResult { get; set; }
        public string state { get; set; }
        public bool isRunning { get; set; }
        public Int64 remainingTime { get; set; }
    }

    public class SystemDeliveryInfoForJson
    {
        public UInt32 systemDeliveryProtocolVersion { get; set; }
        public UInt32 applicationDeliveryProtocolVersion { get; set; }
        public string systemUpdateId { get; set; }
        public UInt32 systemUpdateVersion { get; set; }
        public UInt32 attributes { get; set; }

        public static SystemDeliveryInfoForJson Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<SystemDeliveryInfoForJson>(output);
        }
    }

    public class ApplicationDeliveryInfoForJson
    {
        public string id { get; set; }
        public UInt32 version { get; set; }
        public UInt32 requiredVersion { get; set; }
        public UInt32 requiredSystemVersion { get; set; }
        public UInt32 attributes { get; set; }
        public UInt32 applicationDeliveryProtocolVersion { get; set; }

        public static List<ApplicationDeliveryInfoForJson> Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<List<ApplicationDeliveryInfoForJson>>(output);
        }
    }

    public class LocalContentShareHandlingForJson
    {
        public UInt32 state { get; set; }
        public UInt32 reason { get; set; }
        public string context { get; set; }
        public ErrorContextForJson errorContext { get; set; }

        public static LocalContentShareHandlingForJson Deserialize(string output)
        {
            const string Header = "=== JSON ===";
            var index = output.IndexOf(Header);
            if (index < 0)
            {
                return null;
            }
            return new JavaScriptSerializer().Deserialize<LocalContentShareHandlingForJson>(output.Substring(index + Header.Length));
        }
    }

    public class SaveDataInfoForJson
    {
        public string id { get; set; }
        public string type { get; set; }
        public UInt64 size { get; set; }
        public UInt64 availableSize { get; set; }
        public UInt64 journalSize { get; set; }
        public int flags { get; set; }
        public int flagsFailureResult { get; set; }
        public string spaceId { get; set; }
        public string applicationId { get; set; }
        public string systemId { get; set; }
        public string userId0 { get; set; }
        public string userId1 { get; set; }
        public string ownerId { get; set; }
        public UInt64 timestamp { get; set; }

        public static List<SaveDataInfoForJson> Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<List<SaveDataInfoForJson>>(output);
        }
    }

    public class StorageSize
    {
        public UInt64 free { get; set; }
        public UInt64 total { get; set; }

        public static StorageSize Deserialize(string output)
        {
            StorageSize size = new StorageSize();
            Regex freeRegex = new Regex(@"Free space\s+(\d+)");
            Regex totalRegex = new Regex(@"Total space\s+(\d+)");

            var freeMatch = freeRegex.Match(output);
            if (!freeMatch.Success)
            {
                throw new ArgumentException("Cannot parse output string for storage size");
            }
            size.free = UInt64.Parse(freeMatch.Groups[1].Value);

            var totalMatch = totalRegex.Match(output);
            if (!totalMatch.Success)
            {
                throw new ArgumentException("Cannot parse output string for storage size");
            }
            size.total = UInt64.Parse(totalMatch.Groups[1].Value);

            return size;
        }
    }

    public class SystemProgramList
    {
        public string id { get; set; }
        public UInt32 version { get; set; }
        public string type { get; set; }
        public string name { get; set; }

        public static List<SystemProgramList> Deserialize(string output)
        {
            List<SystemProgramList> list = new List<SystemProgramList>();
            using (var sr = new StringReader(output))
            {
                while (sr.Peek() > -1)
                {
                    var line = sr.ReadLine();
                    if (line.IndexOf("id") == 0)
                    {
                        break;
                    }
                }
                Regex regex = new Regex(@"(0x[0-9a-fA-F]+)\s+([0-9]+)\s+(\w+)\s+(\w+)");
                while (sr.Peek() > -1)
                {
                    var line = sr.ReadLine();
                    var match = regex.Match(line);
                    if (!match.Success)
                    {
                        throw new ArgumentException("Cannot parse output: " + line);
                    }
                    SystemProgramList entity = new SystemProgramList();
                    entity.id = match.Groups[1].Value;
                    entity.version = UInt32.Parse(match.Groups[2].Value);
                    entity.type = match.Groups[3].Value;
                    entity.name = match.Groups[4].Value;
                    list.Add(entity);
                }
            }

            return list;
        }
    }

    public class ApplicationRecordListForJson
    {
        public string id { get; set; }
        public UInt32 version { get; set; }
        public string type { get; set; }
        public string storage { get; set; }

        public static List<ApplicationRecordListForJson> Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<List<ApplicationRecordListForJson>>(output);
        }
    }

    public class AutoUpdateInfoForJson
    {
        public string patchId { get; set; }
        public UInt32 currentVersion { get; set; }
    }

    public class RequestUpdateInfoForJson
    {
        public string reasonResult { get; set; }
    }

    public class DetailApplicationRecordPropertyForJson
    {
        public string terminateResult { get; set; }
        public AutoUpdateInfoForJson autoUpdateInfo { get; set; }
        public RequestUpdateInfoForJson requestUpdateInfo { get; set; }
    }

    public class DetailApplicationRecordListForJson
    {
        public string id { get; set; }
        public string lastEvent { get; set; }
        public bool isAutoDeleteDisabled { get; set; }
        public bool isAutoUpdateEnabled { get; set; }
        public Int64 lastUpdated { get; set; }
        public DetailApplicationRecordPropertyForJson property { get; set; }

        public static List<DetailApplicationRecordListForJson> Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<List<DetailApplicationRecordListForJson>>(output);
        }
    }

    public class GameCardMountStatusForJson
    {
        public Int64 sequence { get; set; }
        public bool isAttached { get; set; }
        public UInt32 lastMountFailureResult { get; set; }

        public static GameCardMountStatusForJson Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<GameCardMountStatusForJson>(output);
        }
    }

    public class ContentMetaKeyForJson
    {
        public UInt64 id { get; set; }
        public UInt32 version { get; set; }
        public int type { get; set; }
        public int installType { get; set; }
    }

    public class LocalContentShareErrorContextForJson
    {
        public string applicationId { get; set; }
        public UInt32 resultInnerValue { get; set; }
        public UInt32 ip { get; set; }
        public bool isSender { get; set; }
        public bool isApplicationRequest { get; set; }
        public bool hasExFatDriver { get; set; }
        public int numKey { get; set; }
        public List<ContentMetaKeyForJson> keyList { get; set; }
    }

    public class ErrorContextForJson
    {
        public int type { get; set; }
        public LocalContentShareErrorContextForJson localContentShare { get; set; }
    }

    public enum ErrorContextType
    {
        None,
        Http,
        FileSystem,
        WebMediaPlayer,
        LocalContentShare
    }

    public class ApplicationRightsOnClientForJson
    {
        public string id { get; set; }
        public string uid { get; set; }
        public string type { get; set; }
        public bool hasAvailableRights { get; set; }
        public bool hasUnavailableRights { get; set; }
        public bool hasAccountRestrictedRights { get; set; }
        public bool recommendInquireServer { get; set; }
        public bool hasPrepurchasedRights  { get; set; }

        public static List<ApplicationRightsOnClientForJson> Deserialize(string output)
        {
            return new JavaScriptSerializer().Deserialize<List<ApplicationRightsOnClientForJson>>(output);
        }
    }


}
