﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <stddef.h>
#include <stdint.h>

void FuncInt(int);
void FuncInt8(int8_t);
void FuncInt16(int16_t);
void FuncInt32(int32_t);
void FuncInt64(int64_t);
void FuncUint8(uint8_t);
void FuncUint16(uint16_t);
void FuncUint32(uint32_t);
void FuncUint64(uint64_t);
void FuncSize(size_t);
void FuncPtrDiff(ptrdiff_t);
void FuncUintPtr(uintptr_t);
void FuncBool(bool);
void FuncChar(char);
void FuncChar16(char16_t);
void FuncFloat(float);
void FuncDouble(double);
void FuncSignedChar(signed char);              //:) BAD
void FuncUnsignedChar(unsigned char);          //:) BAD
void FuncShort(short);                         //:) BAD
void FuncSignedShort(signed short);            //:) BAD
void FuncUnsignedShort(unsigned short);        //:) BAD
void FuncSignedInt(signed int);                //:) DONTCARE
void FuncUnsignedInt(unsigned int);            //:) BAD
void FuncLong(long);                           //:) BAD
void FuncSignLong(signed long);                //:) BAD
void FuncUnsignedLong(unsigned long);          //:) BAD
void FuncLongLong(long long);                  //:) BAD
void FuncSignedLongLong(signed long long);     //:) BAD
void FuncUnsignedLongLong(unsigned long long); //:) BAD
void FuncLongDouble(long double);              //:) BAD
void FuncWchar(wchar_t);                       //:) BAD
void FuncIntPtr(intptr_t);                     //:) BAD
void FuncIntMax(intmax_t);                     //:) BAD
void FuncUintMax(uintmax_t);                   //:) BAD
void FuncIntFast8(int_fast8_t);                //:) BAD
void FuncIntFast16(int_fast16_t);              //:) BAD
void FuncIntFast32(int_fast32_t);              //:) BAD
void FuncIntFast64(int_fast64_t);              //:) BAD
void FuncIntLeast8(int_least8_t);              //:) BAD
void FuncIntLeast16(int_least16_t);            //:) BAD
void FuncIntLeast32(int_least32_t);            //:) BAD
void FuncIntLeast64(int_least64_t);            //:) BAD

class Sample
{
private:

    int                varInt;
    int8_t             varInt8;
    int16_t            varInt16;
    int32_t            varInt32;
    int64_t            varInt64;
    uint8_t            varUint8;
    uint16_t           varUint16;
    uint32_t           varUint32;
    uint64_t           varUint64;
    size_t             varSize;
    ptrdiff_t          varPtrDiff;
    uintptr_t          varUintPtr;
    bool               varBool;
    char               varChar;
    char16_t           varChar16;
    float              varFloat;
    double             varDouble;

    signed char        varSignChar;            //:) BAD
    unsigned char      varUnsignedChar;        //:) BAD
    short              varShoft;               //:) BAD
    signed short       varSignShort;           //:) BAD
    unsigned short     varUnsignedShort;       //:) BAD
    signed int         varSignInt;             //:) DONTCARE
    unsigned int       varUnsignedInt;         //:) BAD
    long               varLong;                //:) BAD
    signed long        varSignLong;            //:) BAD
    unsigned long      varUnsignedLong;        //:) BAD
    long long          varLongLong;            //:) BAD
    signed long long   varSignedLongLong;      //:) BAD
    unsigned long long varUnsignedLongLong;    //:) BAD
    long double        varLongDouble;          //:) BAD
    wchar_t            varWchar;               //:) BAD
    intptr_t           varIntPtr;              //:) BAD
    intmax_t           varIntMax;              //:) BAD
    uintmax_t          varUintMax;             //:) BAD
    int_fast8_t        varIntFast8;            //:) BAD
    int_fast16_t       varIntFast16;           //:) BAD
    int_fast32_t       varIntFast32;           //:) BAD
    int_fast64_t       varIntFast64;           //:) BAD
    int_least8_t       varIntLeast8;           //:) BAD
    int_least16_t      varIntLeast16;          //:) BAD
    int_least32_t      varIntLeast32;          //:) BAD
    int_least64_t      varIntLeast64;          //:) BAD
};

int main(int argc, char* argv[])
{
    int                varInt;
    int8_t             varInt8;
    int16_t            varInt16;
    int32_t            varInt32;
    int64_t            varInt64;
    uint8_t            varUint8;
    uint16_t           varUint16;
    uint32_t           varUint32;
    uint64_t           varUint64;
    size_t             varSize;
    ptrdiff_t          varPtrDiff;
    uintptr_t          varUintPtr;
    bool               varBool;
    char               varChar;
    char16_t           varChar16;
    float              varFloat;
    double             varDouble;

    signed char        varSignChar;            //:) BAD
    unsigned char      varUnsignedChar;        //:) BAD
    short              varShoft;               //:) BAD
    signed short       varSignShort;           //:) BAD
    unsigned short     varUnsignedShort;       //:) BAD
    signed int         varSignInt;             //:) DONTCARE
    unsigned int       varUnsignedInt;         //:) BAD
    long               varLong;                //:) BAD
    signed long        varSignLong;            //:) BAD
    unsigned long      varUnsignedLong;        //:) BAD
    long long          varLongLong;            //:) BAD
    signed long long   varSignedLongLong;      //:) BAD
    unsigned long long varUnsignedLongLong;    //:) BAD
    long double        varLongDouble;          //:) BAD
    wchar_t            varWchar;               //:) BAD
    intptr_t           varIntPtr;              //:) BAD
    intmax_t           varIntMax;              //:) BAD
    uintmax_t          varUintMax;             //:) BAD
    int_fast8_t        varIntFast8;            //:) BAD
    int_fast16_t       varIntFast16;           //:) BAD
    int_fast32_t       varIntFast32;           //:) BAD
    int_fast64_t       varIntFast64;           //:) BAD
    int_least8_t       varIntLeast8;           //:) BAD
    int_least16_t      varIntLeast16;          //:) BAD
    int_least32_t      varIntLeast32;          //:) BAD
    int_least64_t      varIntLeast64;          //:) BAD

    return 0;
}
