﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

namespace classTest
{
    class SampleVar
    {
        static const int m;    //:) BAD
    };

    class SampleField
    {
        int m;                 //:) BAD
    };

    class SampleTemplateFunc
    {
        template <typename T>
        void Func()            //:) BAD
        {
        }
    };

    class SampleFunc
    {
        void Func()            //:) BAD
        {
        }
    };

    class SampleConvertion
    {
        operator bool()        //:) BAD
        {
            return true;
        }
    };

    class SampleClassDecl
    {
        class SubClass         //:) BAD
        {
        };
    };

    class SampleStructDecl
    {
        struct SubClass        //:) BAD
        {
        };
    };

    class SampleTemplateClass
    {
        template <typename T>
        class SubClass         //:) BAD
        {
        };
    };

    class SampleTypedef
    {
        typedef int TestType;  //:) BAD
    };

    class SampleEnum
    {
        enum Sample            //:) BAD
        {
            SAMPLE_CONST
        };
    };
}

namespace structTest
{
    struct SampleVar
    {
        static const int m;
    };

    struct SampleField
    {
        int m;
    };

    struct SampleTemplateFunc
    {
        template <typename T>
        void Func()
        {
        }
    };

    struct SampleFunc
    {
        void Func()
        {
        }
    };

    struct SampleConvertion
    {
        operator bool()
        {
            return true;
        }
    };

    struct SampleClassDecl
    {
        class SubClass
        {
        };
    };

    struct SampleStructDecl
    {
        struct SubClass
        {
        };
    };

    struct SampleTemplateClass
    {
        template <typename T>
        class SubClass
        {
        };
    };

    struct SampleTypedef
    {
        typedef int TestType;
    };

    struct SampleEnum
    {
        enum Sample
        {
            SAMPLE_CONST
        };
    };
}

namespace classPrivateTest
{
    class SampleVar
    {
    private:
        static const int m;
    };

    class SampleField
    {
    private:
        int m;
    };

    class SampleTemplateFunc
    {
    private:
        template <typename T>
        void Func()
        {
        }
    };

    class SampleFunc
    {
    private:
        void Func()
        {
        }
    };

    class SampleConvertion
    {
    private:
        operator bool()
        {
            return true;
        }
    };

    class SampleClassDecl
    {
    private:
        class SubClass
        {
        };
    };

    class SampleStructDecl
    {
    private:
        struct SubClass
        {
        };
    };

    class SampleTemplateClass
    {
    private:
        template <typename T>
        class SubClass
        {
        };
    };

    class SampleTypedef
    {
    private:
        typedef int TestType;
    };

    class SampleEnum
    {
    private:
        enum Sample
        {
            SAMPLE_CONST
        };
    };
}

namespace classProtectedTest
{
    class SampleVar
    {
    protected:
        static const int m;
    };

    class SampleField
    {
    protected:
        int m;
    };

    class SampleTemplateFunc
    {
    protected:
        template <typename T>
        void Func()
        {
        }
    };

    class SampleFunc
    {
    protected:
        void Func()
        {
        }
    };

    class SampleConvertion
    {
    protected:
        operator bool()
        {
            return true;
        }
    };

    class SampleClassDecl
    {
    protected:
        class SubClass
        {
        };
    };

    class SampleStructDecl
    {
    protected:
        struct SubClass
        {
        };
    };

    class SampleTemplateClass
    {
    protected:
        template <typename T>
        class SubClass
        {
        };
    };

    class SampleTypedef
    {
    protected:
        typedef int TestType;
    };

    class SampleEnum
    {
    protected:
        enum Sample
        {
            SAMPLE_CONST
        };
    };
}

namespace classPublicTest
{
    class SampleVar
    {
    public:
        static const int m;
    };

    class SampleField
    {
    public:
        int m;
    };

    class SampleTemplateFunc
    {
    public:
        template <typename T>
        void Func()
        {
        }
    };

    class SampleFunc
    {
    public:
        void Func()
        {
        }
    };

    class SampleConvertion
    {
    public:
        operator bool()
        {
            return true;
        }
    };

    class SampleClassDecl
    {
    public:
        class SubClass
        {
        };
    };

    class SampleStructDecl
    {
    public:
        struct SubClass
        {
        };
    };

    class SampleTemplateClass
    {
    public:
        template <typename T>
        class SubClass
        {
        };
    };

    class SampleTypedef
    {
    public:
        typedef int TestType;
    };

    class SampleEnum
    {
    public:
        enum Sample
        {
            SAMPLE_CONST
        };
    };
}
