﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;
using CodingCheckerUtil;
using PushChecker;
using System;
using System.Linq;

namespace PushCheckerTest
{
    [TestClass]
    public class UtilsTest
    {
        [TestMethod]
        public void CanParsePrePushInput()
        {
            var s =
                "refs/heads/feature/A 3e006239eacac7201786056d4183aa00b79bcd47 refs/heads/feature/A 0000000000000000000000000000000000000000\n" +
                "refs/heads/feature/B 3e2b067da87472ad7db2620016d13fcfad9028e4 refs/heads/feature/B 0000000000000000000000000000000000000000\n" +
                "\n";

            var expected = new[]
            {
                new PushInfo(
                    new RefInfo("refs/heads/feature/A", "3e006239eacac7201786056d4183aa00b79bcd47"),
                    new RefInfo("refs/heads/feature/A", "0000000000000000000000000000000000000000")),
                new PushInfo(
                    new RefInfo("refs/heads/feature/B", "3e2b067da87472ad7db2620016d13fcfad9028e4"),
                    new RefInfo("refs/heads/feature/B", "0000000000000000000000000000000000000000")),
            };

            CollectionAssert.AreEqual(expected, PushChecker.Utils.ParsePrePushInput(s).ToArray());
        }
    }
}
