﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <chrono>
#include <nnt/base/testBase_Exit.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include "TmUtilityWrapper.h"

/*
*   単体テスト
*   事前に Target Manager にターゲットに接続し、LogTestApp を起動しておく必要があります。
*   実行時には引数で対象ターゲットのシリアル番号を指定してください。
*/

namespace
{
    SerialNumberString g_SerialNumber;
    TmUtilityWrapper g_TmUtilityWrapper;

    class Basic : public ::testing::Test
    {
    protected:
        static void SetUpTestCase()
        {
            ASSERT_TRUE(g_TmUtilityWrapper.TryLoadLibrary());
            ASSERT_TRUE(g_TmUtilityWrapper.TryLoadFunctions());
        }

        virtual void SetUp()
        {
        }

        virtual void TearDown()
        {
        }
    };
}

TEST_F(Basic, GetConnectedTargets)
{
    int size = 0;
    ASSERT_EQ(TmUtilityResult_Success, g_TmUtilityWrapper.m_GetConnectedTargetCountFunction(&size));
    EXPECT_LT(0, size);
    printf("%d targets was found\n", size);

    SerialNumberString* serials = reinterpret_cast<SerialNumberString*>(malloc(size * sizeof(SerialNumberString)));

    g_TmUtilityWrapper.m_GetConnectedTargetSerialNumbersFunction(serials, size);

    bool matched = false;
    for (int i = 0; i < size; ++i)
    {
        printf("%s\n", serials[i].value);
        if (strncmp(g_SerialNumber.value, serials[i].value, sizeof(g_SerialNumber.value)) == 0)
        {
            matched = true;
        }
    }
    EXPECT_TRUE(matched);
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    if (argc >= 2)
    {
        strncpy_s(g_SerialNumber.value, argv[1], sizeof(g_SerialNumber.value));
        printf("#######################################\n");
        printf("  Specified serial: %s\n", g_SerialNumber.value);
        printf("#######################################\n");
    }
    else
    {
        printf("Please specify serial number by argv[1]\n");
        nnt::Exit(1);
    }

    ::testing::InitGoogleTest(&argc, argv);

    const int exitCode = RUN_ALL_TESTS();

    nnt::Exit(exitCode);
}

