# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


from params.winpos import WIN_POS

from kiki.util.log import file_logger as logger
from kiki.util import fmttime
from kiki.util import log
import random
import codecs


class Csv_Output(object):
    def __init__(self, columns, path=None):
        self.set_save_path(path)
        
        self.columns = columns
        self.data_list = []
        self.data_list.append( columns )
    
    def get_save_path(self):
        return self.csv_dir

    def set_save_path(self, path=None):
        # print(path is None)
        if path is None or path[-3:] != "csv":  # or path[-3:] != "CSV":
            logger.info("指定がなかったか、「.csv」ファイルでは無かったので「ログ」フォルダにセットしました。")
            self.csv_dir = log.LOG_DIR + fmttime.now_f() + "_" + log.FILE_NAME + ".csv"
        else:
            if path[:5] == "name:":  # ログフォルダでいいけど名前だけは付けたいとき用の隠しモード
                self.csv_dir = log.LOG_DIR + path[5:]
            else:
                self.csv_dir = path

    def make_list(self, columns):
        result = []
        return result

    def add_data(self, factor):
        if len(self.columns) != len(factor):
            logger.warn("見出し列の数と追加しようとしている要素の数が違うよ")
        self.data_list.append( factor )

    def write_csv(self):
        file = codecs.open( self.get_save_path(), 'w', "utf-8-sig")
        for line in self.data_list:
            for data in line:
                file.write( data + "," )
            file.write("\n")

        file.close()
