# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of
from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH


_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"

class MiiGlassEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiGlassEditor, self).__init__(driver)

    def select_glass_parts(self,id):
        id_pos = {
            0:[180,260],
            1:[280,260],
            2:[380,260],
            3:[480,260],
            4:[580,260],
            5:[180,360],
            6:[280,360],
            7:[380,360],
            8:[480,360],
            9:[580,360],
            10:[180,460],
            11:[280,460],
            12:[380,460],
            13:[480,460],
            14:[580,460],
            15:[180,560],
            16:[280,560],
            17:[380,560],
            18:[480,560],
            19:[580,560],
        }
        self.driver.screen.touch(0,x= 210,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def select_glass_placement(self,placement_info):
        # メガネの配置の設定値を上から順にリストでもらい、該当する引数のレベル（パーセンテージ）の位置をタッチする
        #percentage = argument / argument_num
        #touch_bar_point_percent_of(self.driver,start_x=252,start_y=215,angle=0,bar_length=256,percentage=percentage)
        self.driver.screen.touch(0,x= 380,y= 85, ms_after=500)

        arg = placement_info
        max_arg = [20,7]
        percentages = []
        for n in range(len(arg)):
            if arg[n] is not None :
                percentages.append(arg[n] / max_arg[n])
            else:
                percentages.append(arg[n])

        bar_y_pos =300
        for x in percentages:
            if x is not None:
                touch_bar_point_percent_of(self.driver,start_x=252,start_y=bar_y_pos,angle=0,bar_length=256,percentage=x)
            bar_y_pos += 80


    def set_glass_settings(self,glass_parts_id,glass_pos,glass_size,glass_color_id):
        glass_placement = [glass_pos,glass_size]
        if glass_parts_id is not None :self.select_glass_parts(glass_parts_id)
        if glass_parts_id == 0 :
            self.back_to_edit_menu()

        else:
            self.select_glass_placement(glass_placement)
            if glass_color_id is not None:self.select_color_of_parts(glass_color_id)
            self.back_to_edit_menu()
