# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH

_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"

class MiiHokuroEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiHokuroEditor, self).__init__(driver)

    def select_hokuro_parts(self,id):
        id_pos = {
            0:[330,410],
            1:[430,410],
        }

        self.driver.screen.touch(0,x= 270,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def select_hokuro_placement(self,placement_info):
        # 口の配置の設定値を上から順にリストでもらい、該当する引数のレベルの位置をタッチする
        #percentage = argument / argument_num
        #touch_bar_point_percent_of(self.driver,start_x=252,start_y=215,angle=0,bar_length=256,percentage=percentage)
        self.driver.screen.touch(0,x= 490,y= 85, ms_after=500)

        arg = placement_info
        max_arg = [30,16,8]
        percentages = []
        for n in range(len(arg)):
            if arg[n] is not None :
                percentages.append(arg[n] / max_arg[n])
            else:
                percentages.append(arg[n])

        bar_y_pos =260
        for x in percentages:
            if x is not None:
                touch_bar_point_percent_of(self.driver,start_x=252,start_y=bar_y_pos,angle=0,bar_length=256,percentage=x)
            bar_y_pos += 80

    def set_hokuro_settings(self,hokuro_parts_id,hokuro_pos_y,hokuro_pos_x,hokuro_size):
        hokuro_placement = [hokuro_pos_y,hokuro_pos_x,hokuro_size]
        if hokuro_parts_id is not None : self.select_hokuro_parts(hokuro_parts_id)
        if hokuro_parts_id == 0:
            self.back_to_edit_menu()
        else:
            self.select_hokuro_placement(hokuro_placement)
            self.back_to_edit_menu()

