# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from res.res_path import RES_PATH
from kiki.util.log import file_logger as logger




_ICON_IMAGE_PATH = RES_PATH + "/news_list/"


class NewsList(BaseScene):
    def __init__(self, driver):
        super(NewsList, self).__init__(driver)
        self.driver = driver

    def is_available(self):
        icon_image_list = [
                           _ICON_IMAGE_PATH + "ss_news_list_title_jp.PNG",
                           _ICON_IMAGE_PATH + "ss_news_list_title_us_en.PNG",
                            ]

        for icon_image in icon_image_list:
            if self.driver.screen.detect_object_with_image(icon_image) is not None:
                return True

            else:
                return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してNEWSに遷移したかを判定する（直接ニュース詳細に遷移した場合はうまく動作しないかもしれない）
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str=".*\[Started\].*scene\[SceneNotification\]", ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def open_news_at_upper_left(self):
        logger.debug(u"一番左上のニュースをタッチしてニュースを表示します")
        self.driver.screen.touch(0,x=110, y=150, ms_after=500)


    def close_news_list(self):
        logger.debug(u"フッタのリターンアイコンをタッチしてニュースリストを閉じます")
        self.driver.screen.touch(0,x=100, y=680, ms_after=2000)




class NewsDetail(NewsList):
    def __init__(self, driver):
        super(NewsList, self).__init__(driver)
        self.driver = driver

    def is_available(self):
        icon_image_list = [
                           _ICON_IMAGE_PATH + "ss_news_channel_info_JP.png"
                            ]

        for icon_image in icon_image_list:
            if self.driver.screen.detect_object_with_image(icon_image) is not None:
                return True

            else:
                return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してNEWS詳細に遷移したかを判定する）
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<qlaunch\>.*Scene Jump end \(success\) \[\/RootScene\/SceneNotification\/SceneNtfViewer.*\]", ms_timeout=10000,is_reverse=False)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def go_to_next_news(self):
        logger.debug(u"Rボタンを押下して次のニュースを表示します")
        self.driver.controllers[0].push("R", ms_after=500)

    def go_to_previous_news(self):
        logger.debug(u"Lボタンを押下して1つ前のニュースを表示します")
        self.driver.controllers[0].push("L", ms_after=500)

    def check_effective_A_button(self):
        logger.info("フッターにAボタンアイコンが表示されているか確認します")
        icon_image = _ICON_IMAGE_PATH + "ss_news_icon_A_button.png"
        result = self.driver.screen.detect_object_with_image(icon_image, threshold=0.95, shows_result=False)
        if result is not None:
            logger.info("Aボタンが表示されているニュースです")
            return True
        else:
            logger.info("Aボタンが表示されていないニュースです")
            return False

    def back_to_news_list(self):
        result = self.check_effective_A_button()
        logger.debug(u"もどるをタッチしてニュース一覧に戻ります")
        if result:
            self.driver.screen.touch(0,x=1000, y=685, ms_after=400)
        else:
            self.driver.screen.touch(0, x=1160, y=685, ms_after=400)
        icon_image_list = [
                           _ICON_IMAGE_PATH + "ss_news_list_title_jp.PNG",
                           _ICON_IMAGE_PATH + "ss_news_list_title_us_en.PNG",
                            ]
        self.driver.screen.wait_until_detect_object(icon_image_list,threshold=0.7, limit_count=50)

