# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time
import datetime
from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from scenes.home_menu.sandbox import SandBox
from res.res_path import RES_PATH

from kiki.util.log import file_logger as logger
from scenes.main_setting.main_setting import MainSetting

_ICON_IMAGE_PATH = RES_PATH + "/home_menu/"

class HomeMenu(BaseScene):
    def __init__(self, driver):
        super(HomeMenu, self).__init__(driver)

    def is_available(self):
        setting_icon = _ICON_IMAGE_PATH + "setting_icon.png"
        if self.driver.screen.detect_object_with_image(setting_icon) is not None:
            return True
        else:
            return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してHOMEにいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<qlaunch\>.*\[ResidentMenu\].*\[TransittedToResidentMenu\]|\<qlaunch\>.*\[ResidentMenu\].*\[SceneDestroyed\]"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            setting_icon = _ICON_IMAGE_PATH + "ss_sa_icon_setting.PNG"
            if self.driver.screen.detect_object_with_image(setting_icon) is not None:
                return True
            else:
                return False


    def search_icon(self, icon_image_list, threshold=0.8, shows_result=False):
        """ホーム画面からアイコンを探す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        if not self.is_available():
            logger.warn("ホームメニューにいません。")
            return None

        self.driver.controllers[0].push("START", ms_after=500) # TODO: HOMEボタン対応後、HOMEボタンに変える

        full_launcher_L_bunner = _ICON_IMAGE_PATH+"full_launcher_L_banner.png"
        while self.driver.window.detect_object(full_launcher_L_bunner) is None:
            result = self._search_icon_from_image_list(icon_image_list, shows_result=shows_result)
            if result is not None:
                return result
            else:
                self.driver.controllers[0].push("RIGHT", ms_after=500)

        logger.info("アイコン見つからなかった…")
        return None

    def get_imread_result_list(self, icon_path_list):
        result_list = []
        for icon_path in icon_path_list:
            icon_image = _ICON_IMAGE_PATH + icon_path
            result_list.append(icon_image)

        return result_list

    def wait_until_detect_object(self, name, threshold=0.8, limit_count=60, shows_result=False):
        icon = []
        if type(name) == list:
            icon = self.get_imread_result_list(name)
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon.append(icon_image)

        if self.driver.screen.wait_until_detect_object(icon, threshold=threshold, limit_count=limit_count, shows_result=shows_result) is not None:
            return True
        else:
            return False

    def select_sandbox(self, shows_result=False):
        """sandboxアイコンを探して選択する

        :param shows_result:
        :return:
        """
        sandbox_icons = [_ICON_IMAGE_PATH + "selected_sandbox_icon.png"]

        result = self.search_icon(sandbox_icons, threshold=0.95)

        if result is not None:
            logger.info("sandboxへ遷移します")
            self.driver.controllers[0].push("A", ms_after=5000)
            return SandBox(driver=self.driver)

        else:
            logger.warn("sandboxアイコンが選択できませんでした。")
            return None

    def select_system_applet(self, app_name, id=0):
        """HOMEメニュー下段の指定されたSAを起動する(ニュースリスト～スリープ まで)

        :param app_name:
        :param id:
        :return:
        """
        # きぐちめも：
        # ※いかなる状況でも指定されたアイコンの座標を2回押してしまう
        # 　→すでにカーソルが当たっている場合余分に1回タッチすることになる
        # ※画面遷移はするけれど、各画面のis_available が行えていない
        # 　加えて遷移先のシーンオブジェクトも返せていない
        # ⇒各アプレットへの transition_to～ 関数を用意して、
        # 　ここの処理はそれぞれへ誘導するだけに変えるかも。

        app_icon_dict = {
            "news_list": "ss_sa_icon_news_list.PNG",
            "eShop": "ss_sa_icon_shop.PNG",
            "album": "ss_sa_icon_album.PNG",
            "controller": "ss_sa_icon_controller.PNG",
            "main_setting": "ss_sa_icon_main_setting.PNG",
            "sleep": "ss_sa_icon_sleep.PNG"
        }

        trg_img = app_icon_dict[app_name]
        trg_icon = _ICON_IMAGE_PATH + trg_img

        result = self.driver.screen.detect_object_with_image(trg_icon)
        if result is not None:
            logger.info(app_name + "へ遷移します")
            for i in range(2):
                self.driver.screen.touch(0, x=result[0]+20, y=result[1]+40, ms_after=500)
            #self.driver.controllers[id].push("A", ms_after=3000)
            return True
        else:
            return None

    def is_selected_main_setting(self):
        icon_name_list = ["selected_main_setting_icon.png",
                          "selected_main_setting_icon_USen.png",
                          "selected_main_setting_icon_EUen.png"]

        for icon_name in icon_name_list:
            trg_icon = _ICON_IMAGE_PATH + icon_name
            result = self.driver.screen.detect_object_with_image(trg_icon)
            if result is not None:
                return result
        return None

    def transition_to_main_setting(self, logstore):
        num = 2
        if self.is_selected_main_setting() is not None:
            num = 1

        logstore.move_pointer_newest()
        for i in range(num):
            self.driver.screen.touch(0, 810, 570, ms_after=1500)

        main_setting =  MainSetting(driver=self.driver)
        result_by_image = main_setting.is_available()
        result_by_log = main_setting.is_available_from_log(logstore)
        if result_by_image or result_by_log:
            return main_setting
        else:
            logger.info("設定画面に居ません")
            return main_setting # None返すのはやめてます

    def select_app_on_qlaunch(self, app_name, id=0):

        ### HOMEメニューからapp_nameのアイコンを探してタッチする ###座標も返す
        app_icon_image = {
            "applet_caller" :[_ICON_IMAGE_PATH + "ss_app_icon_applet_caller_active.PNG",
                              _ICON_IMAGE_PATH + "ss_app_icon_applet_caller_nonactive.PNG"],
            "sandbox": [_ICON_IMAGE_PATH + "ss_app_icon_sandbox_active.PNG",
                        _ICON_IMAGE_PATH + "ss_app_icon_sandbox_nonactive.PNG"],
            "dummy" :  [_ICON_IMAGE_PATH + "ss_app_icon_dummy_active.PNG",
                        _ICON_IMAGE_PATH + "ss_app_icon_dummy_nonactive.PNG"],
            "full_launcher" : [_ICON_IMAGE_PATH + "ss_homemenu_full_launcher_active.PNG",
                             _ICON_IMAGE_PATH + "ss_homemenu_full_launcher_nonactive.PNG"],
            "splatoon" : [_ICON_IMAGE_PATH + "ss_app_icon_splatoon_active.PNG",
                             _ICON_IMAGE_PATH + "ss_app_icon_splatoon_nonactive.PNG"],
            "butumori" : [_ICON_IMAGE_PATH + "ss_app_icon_butumori_active.PNG",
                             _ICON_IMAGE_PATH + "ss_app_icon_butumori_nonactive.PNG"]
        }
        self.return_cursor_to_origin()
        self.driver.screen.swipe(0, start_x=300, start_y=350, angle_deg=180.0, length=50.0,ms_after=500)

        for search_count in range(4):
            result = None
            for icon_image in app_icon_image[app_name]:
                result = self.driver.screen.detect_object_with_image(icon_image, threshold=0.7, shows_result=False)
                if result is not None : break
            if result is not None:
                    logger.debug(str(app_name)+u"アプリアイコン発見")
                    #logger.debug(str(app_name)+u"を起動します")
                    self.driver.screen.touch(0,x= result[0]+20,y= result[1]+20, ms_after=800)
                    return result
            else:
                logger.debug(str(app_name)+u"アプリアイコンがみつかりません")
                logger.debug(u"右方向にスクロールします")
                self.driver.screen.swipe(0, start_x=1100, start_y=350, angle_deg=180.0, length=800.0,ms_after=500)
        else:
            logger.debug(u"クイックランチャー上に"+str(app_name)+u"アプリアイコンがみつかりません")
            return None

    def is_in_applet_caller(self):
        ### applet_caller にいるかをapplet_caller トップ画像の有無で判定 ###(将来的にこれ系はログの方が安全かも)
        applet_caller_top = _ICON_IMAGE_PATH + "ss_applet_caller_top.PNG"
        if self.driver.screen.detect_object_with_image(applet_caller_top) is not None:
            return True
        else:
            return False

    def is_in_controller_support(self):
        ### コンサポ にいるかをコンサポトップのNX画像の有無で判定 ###(将来的にこれ系はログの方が安全かも)
        applet_caller_top = _ICON_IMAGE_PATH + "ss_controller_support_top.PNG"
        if self.driver.screen.detect_object_with_image(applet_caller_top) is not None:
            return True
        else:
            return False

    def open_option_cur_app(self):
        # きぐめも：オプションメニューのアイコンがみつからなかった場合に、
        # 何も return してなかったのが違和感あったので、どちらにしても result を返すよう変更しました。
        option_image = _ICON_IMAGE_PATH + "ss_option_icon.PNG"
        result = self.driver.screen.detect_object_with_image(option_image)
        if result is not None :
            self.driver.screen.touch(0,x=result[0] ,y= result[1], ms_after=500)
            logger.debug("オプションメニューを開きます")
        else:
            logger.debug("オプションメニューのアイコンがみつかりません")
        return result

    def update_app(self):
        pass

    def delete_app_self(self):
        ### オプションメニューが開いた状態からアプリの消去を実行する ###
        # 念のため、左側のメニュー最上部にカーソルを置いてから操作を始めます。
        self.driver.controllers[0].push("UP", ms_press=1000, ms_after=300)
        self.driver.controllers[0].push("DOWN", ms_after=300)
        self.driver.controllers[0].push("A", ms_after=300)

        # 右側「ソフトの消去」を選んで、消去実行
        # [2.0.0]「ソフトの消去」の1つ上に「データの整理」が増えているので1回 DOWN 押下が必要になりました。
        self.driver.controllers[0].push("DOWN", ms_after=500) # ms_after はとりあえずの値です。
        self.driver.controllers[0].push("A", ms_after=500)
        self.driver.controllers[0].push("A", ms_after=300)
        image = _ICON_IMAGE_PATH + "ss_finished_delete_app.PNG"
        if self.driver.screen.wait_until_detect_object(image,threshold=0.8,limit_count=100) is not None:
            self.driver.controllers[0].push("A", ms_after=1000)
        else:
            logger.info("ソフトの消去に失敗している可能性があります。HOMEボタンを押下します。")
            self.driver.controllers[0].push("HOME", ms_after=1000)

        # タッチ操作版
        """
        self.driver.screen.touch(0,x=250 ,y= 290, ms_after=1000)
        self.driver.screen.touch(0,x=600 ,y= 470, ms_after=1000)
        self.driver.screen.touch(0,x=815 ,y= 470, ms_after=500)
        image = _ICON_IMAGE_PATH + "ss_finished_delete_app.PNG"
        self.driver.screen.wait_until_detect_object(image,threshold=0.8,limit_count=100)
        self.driver.screen.touch(0,x=640 ,y= 465, ms_after=500)
        """

    def start_check_sequence_for_register_npg(self):
        ### オプションメニューが開いた状態から、「登録できるかチェック」を実行する ###
        self.driver.screen.touch(0,x=250 ,y= 365, ms_after=500)
        self.driver.screen.touch(0,x=750 ,y= 300, ms_after=500)

    def return_cursor_to_origin(self):
        self.driver.controllers[0].push("HOME", ms_after=1000)
        if self.is_available() is not True:
            self.driver.controllers[0].push("HOME", ms_after=500)
            #self.driver.controllers[0].push("X", ms_after=500)
            #self.driver.controllers[0].push("A", ms_after=500)
        else:
            pass

    def select_app_on_full_launcher(self, app_name, id=0):

        ### フルランチャーからapp_nameのアイコンを探してタッチする ###座標も返す
        app_icon_image = {
            "applet_caller" :_ICON_IMAGE_PATH + "ss_fulllauncher_app_icon_applet_caller.PNG",
            "sandbox": _ICON_IMAGE_PATH + "ss_fulllauncher_app_icon_sandboxPNG.PNG",
            "splatoon" : _ICON_IMAGE_PATH + "ss_fulllauncher_app_icon_splatoon.PNG"
        }
        self.return_cursor_to_origin()
        self.driver.screen.swipe(0, start_x=300, start_y=350, angle_deg=180.0, length=50.0,ms_after=500)

        for search_count in range(4):
            result = None
            for icon_image in app_icon_image[app_name]:
                result = self.driver.screen.detect_object_with_image(icon_image, threshold=0.7, shows_result=False)
                if result is not None : break
            if result is not None:
                    logger.debug(str(app_name)+u"アプリアイコン発見")
                    #logger.debug(str(app_name)+u"を起動します")
                    self.driver.screen.touch(0,x= result[0],y= result[1], ms_after=500)
                    return result
            else:
                logger.debug(str(app_name)+u"アプリアイコンがみつかりません")
                logger.debug(u"右方向にスクロールします")
                self.driver.screen.swipe(0, start_x=1100, start_y=350, angle_deg=180.0, length=800.0,ms_after=500)
                if search_count is 3 :
                    logger.debug(u"クイックランチャー上に"+str(app_name)+u"アプリアイコンがみつかりません")
                    return False

