# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from scenes.base_scene import BaseScene
from res.res_path import RES_PATH


_ICON_IMAGE_PATH = RES_PATH + "/entrance/"

class TEntrance(BaseScene):
    def __init__(self, driver):
        super(TEntrance, self).__init__(driver)

    def is_available(self):
        image = _ICON_IMAGE_PATH + "ss_entrance_anchor.PNG"
        if self.driver.screen.detect_object_with_image(image) is not None:
            return True
        else:
            return False

    def wake_by_power_button(self):
        self.driver.hardware_em.press_power_button(1)
        time.sleep(5)