# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH



_ICON_IMAGE_PATH = RES_PATH + "/devmenu/"

class DevMenu(BaseScene):
    def __init__(self, driver):
        super(DevMenu, self).__init__(driver)

    def is_available(self):
        pass

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def touch_application_icon(self):
        application_image = [
            _ICON_IMAGE_PATH + "ss_devmenu_application_1.PNG",
            _ICON_IMAGE_PATH + "ss_devmenu_application_2.PNG",
            _ICON_IMAGE_PATH + "ss_devmenu_application_3.PNG",
            _ICON_IMAGE_PATH + "ss_devmenu_application_4.PNG"
            ]

        result_pos = self._search_icon_from_image_list(icon_image_list = application_image, threshold=0.9, shows_result=False)
        if result_pos is not None:
            self.driver.screen.touch(0,x= result_pos[0]+20,y= result_pos[1]+20, ms_after=500)

        else:
            logger.info("Cannot detect devmenu_application[applicationアイコンがみつかりません]...")

    def launch_app_sysmenu(self):
        sysmenu_image = [
            _ICON_IMAGE_PATH + "ss_devmenu_app_Sysmenu_01.png",
            _ICON_IMAGE_PATH + "ss_devmenu_app_Sysmenu_02.png",
            ]
        result_pos = self._search_icon_from_image_list(icon_image_list = sysmenu_image, threshold=0.8, shows_result=False)
        if result_pos is not None:
            self.driver.screen.touch(0,x= result_pos[0]+20,y= result_pos[1]+20, ms_after=500)

    def launch_app_appletcaller_in_homemenu(self):
        appcaller_image = [_ICON_IMAGE_PATH + "ss_menu_appcaller_1.PNG",]
        result_pos = self._search_icon_from_image_list(icon_image_list = appcaller_image, threshold=0.50, shows_result=True)
        print(result_pos)
        if result_pos is not None:
            self.driver.screen.touch(0,x= result_pos[0],y= result_pos[1], ms_after=500)
            self.driver.screen.touch(0,x= result_pos[0],y= result_pos[1], ms_after=500)
