# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from res.res_path import RES_PATH
from scenes.base_scene import BaseScene

_ICON_IMAGE_PATH = RES_PATH + "/auth/"

class TAuth(BaseScene):
    def __init__(self, driver):
        super(TAuth, self).__init__(driver)

    def is_available(self):
        pass

    def select_moon_setting_by_nx(self, id=0):
        # みまもり設定TOPから、この本体で設定を選ぶまで
        # 中断中のアプリがある場合のシーケンスはフォローしてないので、予め終了させておくこと
        self.driver.controllers[id].push("DOWN", ms_after=1000)
        self.driver.controllers[id].push("A", ms_after=1000)
        self.driver.controllers[id].push("DOWN", ms_after=1000)
        self.driver.controllers[id].push("A", ms_after=1000)

    def select_safe_level(self, level, id=0):
        # カスタム設定を選んだあとの詳細な変更はここではフォローしない。

        level_dict = { "None": 0,
                       "Teens": 1,
                       "Child": 2,
                       "Kids": 3,
                       "Custom": 4 }

        self.driver.controllers[id].push("A", ms_after=1000)
        self.driver.controllers[id].push("UP", ms_press=1500, ms_after=1000) # 一番上へ。
        for i in range(level_dict[level]):
            self.driver.controllers[id].push("DOWN", ms_after=500)
        self.driver.controllers[id].push("A", ms_after=1000)

        if level == "Custom":
            self.driver.controllers[id].push("RIGHT", ms_after=500)
        self.driver.controllers[id].push("RIGHT", ms_after=500)
        self.driver.controllers[id].push("A", ms_after=1000)

    def is_registered_moon_setting(self, id=0):
        image = _ICON_IMAGE_PATH + "saved_safe_level_setting.png"
        for i in range(60):
            if self.driver.screen.detect_object_with_image(image) is not None:
                self.driver.controllers[id].push("A", ms_after=1000)
                return True
            else:
                time.sleep(1)
        return False

    def is_deleted_moon_setting(self, id=0):
        image = _ICON_IMAGE_PATH + "deleted_moon_setting.png"
        for i in range(30):
            if self.driver.screen.detect_object_with_image(image) is not None:
                self.driver.controllers[id].push("A", ms_after=1000)
                return True
            else:
                time.sleep(1)
        return False